/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelPromise;
import io.netty.util.Recycler;
import java.util.Arrays;

final class MessageList {
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final int MIN_INITIAL_CAPACITY = 4;
    private static final Recycler<MessageList> RECYCLER = new Recycler<MessageList>(){

        @Override
        protected MessageList newObject(Recycler.Handle handle) {
            return new MessageList(handle);
        }
    };
    private final Recycler.Handle handle;
    private Object[] messages;
    private ChannelPromise[] promises;
    private int size;

    static MessageList newInstance() {
        MessageList ret = RECYCLER.get();
        return ret;
    }

    MessageList(Recycler.Handle handle) {
        this(handle, 8);
    }

    MessageList(Recycler.Handle handle, int initialCapacity) {
        this.handle = handle;
        initialCapacity = MessageList.normalizeCapacity(initialCapacity);
        this.messages = new Object[initialCapacity];
        this.promises = new ChannelPromise[initialCapacity];
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    MessageList add(Object message, ChannelPromise promise) {
        int oldSize = this.size;
        int newSize = oldSize + 1;
        this.ensureCapacity(newSize);
        this.messages[oldSize] = message;
        this.promises[oldSize] = promise;
        this.size = newSize;
        return this;
    }

    Object[] messages() {
        return this.messages;
    }

    ChannelPromise[] promises() {
        return this.promises;
    }

    boolean recycle() {
        Arrays.fill(this.messages, 0, this.size, null);
        Arrays.fill(this.promises, 0, this.size, null);
        this.size = 0;
        return RECYCLER.recycle(this, this.handle);
    }

    private void ensureCapacity(int capacity) {
        if (this.messages.length >= capacity) {
            return;
        }
        int size = this.size;
        capacity = MessageList.normalizeCapacity(capacity);
        Object[] newMessages = new Object[capacity];
        System.arraycopy(this.messages, 0, newMessages, 0, size);
        this.messages = newMessages;
        ChannelPromise[] newPromises = new ChannelPromise[capacity];
        System.arraycopy(this.promises, 0, newPromises, 0, size);
        this.promises = newPromises;
    }

    private static int normalizeCapacity(int initialCapacity) {
        if (initialCapacity <= 4) {
            initialCapacity = 4;
        } else {
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        }
        return initialCapacity;
    }
}

