/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.json.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.vertx.java.core.json.DecodeException;
import org.vertx.java.core.json.EncodeException;

public class Json {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final ObjectMapper prettyMapper = new ObjectMapper();

    public static String encode(Object obj) throws EncodeException {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static String encodePrettily(Object obj) throws EncodeException {
        try {
            return prettyMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new EncodeException("Failed to encode as JSON: " + e.getMessage());
        }
    }

    public static <T> T decodeValue(String str, Class<?> clazz) throws DecodeException {
        try {
            return (T)mapper.readValue(str, clazz);
        }
        catch (Exception e) {
            throw new DecodeException("Failed to decode:" + e.getMessage());
        }
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        prettyMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
    }
}

