/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.web.config.section;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xbean.recipe.ObjectRecipe;
import org.commonjava.web.config.ConfigurationException;
import org.commonjava.web.config.annotation.ConfigName;
import org.commonjava.web.config.annotation.ConfigNames;
import org.commonjava.web.config.section.TypedConfigurationSectionListener;

public class BeanSectionListener<T>
implements TypedConfigurationSectionListener<T> {
    private ObjectRecipe recipe;
    private final Class<T> type;
    private final T instance;
    private final List<String> constructorArgs = new ArrayList<String>();
    private final Map<String, String> propertyMap = new HashMap<String, String>();

    public BeanSectionListener(Class<T> type) {
        this.type = type;
        this.instance = null;
        this.doDiscovery(type);
    }

    public BeanSectionListener(T instance) {
        this.type = instance.getClass();
        this.instance = instance;
        this.doDiscovery(this.type);
    }

    private void doDiscovery(Class<T> type) {
        ArrayList<String> ctorArgs = null;
        for (Constructor<?> constructor : type.getConstructors()) {
            ConfigNames names = constructor.getAnnotation(ConfigNames.class);
            if (names == null) continue;
            if (ctorArgs != null) {
                throw new IllegalArgumentException("Only one constructor can be annotated with @ConfigNames!");
            }
            if (names.value().length != constructor.getParameterTypes().length) {
                throw new IllegalArgumentException("Invalid number of configuration names in @ConfigNames annotation. Expected: " + constructor.getParameterTypes().length + ", got: " + names.value().length);
            }
            ctorArgs = new ArrayList<String>(Arrays.asList(names.value()));
        }
        for (Executable executable : type.getMethods()) {
            ConfigName cn = ((Method)executable).getAnnotation(ConfigName.class);
            if (cn == null) continue;
            String name = ((Method)executable).getName();
            System.out.println("Adding configuration property: " + name);
            if (!Modifier.isPublic(((Method)executable).getModifiers()) || name.length() <= 3 || !name.startsWith("set")) {
                throw new IllegalArgumentException("Invalid configuration method; not accessible, not a setter, or not a valid property name: " + type.getClass().getName() + "." + name);
            }
            String propertyName = name.substring(3);
            propertyName = propertyName.length() > 1 ? Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1) : propertyName.toLowerCase();
            this.propertyMap.put(cn.value(), propertyName);
        }
        this.constructorArgs.clear();
        if (ctorArgs != null && !ctorArgs.isEmpty()) {
            this.constructorArgs.addAll((Collection<String>)ctorArgs);
        }
        this.recipe = new ObjectRecipe(type);
        if (this.constructorArgs != null && !this.constructorArgs.isEmpty()) {
            this.recipe.setConstructorArgNames(this.constructorArgs);
        }
    }

    @Override
    public void sectionStarted(String name) throws ConfigurationException {
    }

    @Override
    public void parameter(String name, String value) throws ConfigurationException {
        String realName = name;
        if ((this.constructorArgs == null || !this.constructorArgs.contains(name)) && this.propertyMap.containsKey(name)) {
            realName = this.propertyMap.get(name);
        }
        this.recipe.setProperty(realName, (Object)value);
    }

    @Override
    public void sectionComplete(String name) throws ConfigurationException {
    }

    @Override
    public T getConfiguration() {
        if (this.instance != null) {
            this.recipe.setProperties(this.instance);
            return this.instance;
        }
        return this.type.cast(this.recipe.create());
    }

    public String toString() {
        return String.format("BeanSectionListener [%s]", this.type.getName());
    }

    @Override
    public Class<T> getConfigurationType() {
        return this.type;
    }
}

