/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.web.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.commonjava.web.config.ConfigurationException;
import org.commonjava.web.config.ConfigurationListener;
import org.commonjava.web.config.ConfigurationRegistry;
import org.commonjava.web.config.DefaultConfigurationListener;
import org.commonjava.web.config.section.ConfigurationSectionListener;

public class DefaultConfigurationRegistry
implements ConfigurationRegistry {
    private final Collection<ConfigurationListener> listeners;
    private Map<String, ConfigurationSectionListener<?>> sectionMap;

    public DefaultConfigurationRegistry() {
        this.listeners = new ArrayList<ConfigurationListener>();
    }

    public DefaultConfigurationRegistry(Class<?> ... types) throws ConfigurationException {
        this(new DefaultConfigurationListener(types));
    }

    public DefaultConfigurationRegistry(ConfigurationSectionListener<?> ... sectionListeners) throws ConfigurationException {
        this(new DefaultConfigurationListener(sectionListeners));
    }

    public DefaultConfigurationRegistry(ConfigurationListener ... listeners) throws ConfigurationException {
        this.listeners = Arrays.asList(listeners);
        this.mapSectionListeners();
    }

    public DefaultConfigurationRegistry(Object ... data) throws ConfigurationException {
        this.listeners = new ArrayList<ConfigurationListener>();
        for (Object d : data) {
            if (d instanceof ConfigurationListener) {
                this.with((ConfigurationListener)d);
                continue;
            }
            if (d instanceof ConfigurationSectionListener) {
                this.with((ConfigurationSectionListener)d);
                continue;
            }
            if (d instanceof Class) {
                this.with((Class)d);
                continue;
            }
            throw new ConfigurationException("Invalid input for configuration registry: %s", d);
        }
    }

    public DefaultConfigurationRegistry with(ConfigurationListener listener) throws ConfigurationException {
        this.listeners.add(listener);
        this.mapListener(listener);
        return this;
    }

    public DefaultConfigurationRegistry with(ConfigurationSectionListener<?> listener) throws ConfigurationException {
        DefaultConfigurationListener dcl = new DefaultConfigurationListener(listener);
        this.listeners.add(dcl);
        this.mapListener(dcl);
        return this;
    }

    public DefaultConfigurationRegistry with(Class<?> type) throws ConfigurationException {
        DefaultConfigurationListener dcl = new DefaultConfigurationListener(type);
        this.listeners.add(dcl);
        this.mapListener(dcl);
        return this;
    }

    @Override
    public void configurationParsed() throws ConfigurationException {
        if (this.listeners != null) {
            for (ConfigurationListener listener : this.listeners) {
                listener.configurationComplete();
            }
        }
    }

    @Override
    public boolean sectionStarted(String name) throws ConfigurationException {
        ConfigurationSectionListener<?> listener = this.sectionMap.get(name);
        if (listener != null) {
            listener.sectionStarted(name);
            return true;
        }
        return false;
    }

    @Override
    public void sectionComplete(String name) throws ConfigurationException {
        ConfigurationSectionListener<?> listener = this.sectionMap.get(name);
        if (listener != null) {
            listener.sectionComplete(name);
        }
    }

    @Override
    public void parameter(String section, String name, String value) throws ConfigurationException {
        ConfigurationSectionListener<?> secListener = this.sectionMap.get(section);
        secListener.parameter(name, value);
    }

    protected synchronized void mapSectionListeners() throws ConfigurationException {
        if (this.listeners != null) {
            for (ConfigurationListener listener : this.listeners) {
                this.mapListener(listener);
            }
        }
    }

    private void mapListener(ConfigurationListener listener) throws ConfigurationException {
        if (this.sectionMap == null) {
            this.sectionMap = new HashMap();
        }
        Map<String, ConfigurationSectionListener<?>> parsers = listener.getSectionListeners();
        for (Map.Entry<String, ConfigurationSectionListener<?>> entry : parsers.entrySet()) {
            String section = entry.getKey();
            if (this.sectionMap.containsKey(section)) {
                throw new ConfigurationException("Section collision! More than one ConfigurationParser bound to section: %s\n\t%s\n\t%s", section, this.sectionMap.get(section), entry.getValue());
            }
            this.sectionMap.put(section, entry.getValue());
        }
    }
}

