/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.rest;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.commonjava.freeki.conf.FreekiConfig;
import org.commonjava.freeki.infra.route.Method;
import org.commonjava.freeki.infra.route.RouteHandler;
import org.commonjava.freeki.infra.route.anno.Route;
import org.commonjava.freeki.infra.route.anno.Routes;
import org.commonjava.freeki.rest.PathParameter;
import org.commonjava.util.logging.Logger;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;

public class StaticContentHandler
implements RouteHandler {
    private final Logger logger = new Logger(this.getClass());
    private final File staticBasedir;

    public StaticContentHandler(FreekiConfig mainConf) {
        this.staticBasedir = new File(mainConf.getBrandingDir(), "static");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Routes(value={@Route(path="/static/:path=(.+)", method=Method.GET)})
    public void get(HttpServerRequest req) throws Exception {
        req.response().setStatusCode(200);
        String path = req.params().get(PathParameter.PATH.param());
        this.logger.info("Serving static path: '%s'", path);
        File f = new File(this.staticBasedir, path);
        if (!f.exists()) {
            String resource = "static/" + path;
            this.logger.info("Path does not exist in static directory: %s; checking for classpath resource: '%s'", this.staticBasedir, resource);
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            if (stream == null) {
                this.logger.info("No dice", new Object[0]);
                req.response().setStatusMessage("Not found").setStatusCode(404).end();
            } else {
                this.logger.info("Sending classpath resource: %s", resource);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy(stream, (OutputStream)baos);
                try {
                    int len = baos.toByteArray().length;
                    Buffer buf = new Buffer(baos.toByteArray());
                    req.response().putHeader("Content-Length", Integer.toString(len)).end(buf);
                }
                finally {
                    IOUtils.closeQuietly(stream);
                }
            }
        } else if (f.isDirectory()) {
            this.logger.info("Requested file is actually a directory!", new Object[0]);
            req.response().setStatusMessage("Content is a directory").setStatusCode(404).end();
        } else {
            this.logger.info("Sending freeki file resource: %s", f.getAbsolutePath());
            req.response().sendFile(f.getAbsolutePath());
        }
    }
}

