/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.model;

import java.io.StringReader;
import java.net.MalformedURLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.LineIterator;
import org.commonjava.freeki.infra.anno.RenderKey;
import org.commonjava.freeki.util.UrlUtils;

@RenderKey(key="page", contentTemplate="${data.content}")
public class Page {
    private String id;
    private String title;
    private Date updated = new Date();
    private String currentAuthor;
    private String content;
    private String group;
    private Map<String, String> metadata = new HashMap<String, String>();

    public Page() {
    }

    public Page(String group, String pageName, String content, String title, long created, String author) throws MalformedURLException {
        this.group = group;
        this.updated = new Date(created);
        this.content = content;
        this.title = title;
        this.currentAuthor = author;
        this.id = Page.serverPathFor(group, pageName);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public String getContent() {
        return this.content;
    }

    public Page setContent(String content) {
        this.content = content;
        return this;
    }

    public void syncContentWithTitle() {
        String title = this.getTitle();
        if (this.content != null) {
            boolean prependTitle = false;
            LineIterator li = new LineIterator(new StringReader(this.content));
            while (li.hasNext()) {
                String line = li.next();
                if (line.trim().length() <= 0) continue;
                if (title == null) {
                    title = line;
                    break;
                }
                if (title == null || line.trim().endsWith(title.trim())) break;
                prependTitle = true;
                break;
            }
            if (prependTitle) {
                this.content = "#" + title + "\n\n" + this.content;
            }
        } else if (title != null) {
            this.content = "#" + title + "\n\n";
        }
        this.setTitle(title);
    }

    public String getTitle() {
        return this.title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getCurrentAuthor() {
        return this.currentAuthor;
    }

    public Page setTitle(String title) {
        this.title = title;
        return this;
    }

    public Page setUpdated(Date updated) {
        this.updated = updated;
        return this;
    }

    public Page setCurrentAuthor(String currentAuthor) {
        this.currentAuthor = currentAuthor;
        return this;
    }

    public Page setGroup(String group) {
        this.group = group;
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean updateFrom(Page pg) {
        if (pg.group != null && !this.group.equals(pg.group)) {
            return false;
        }
        if (pg.title != null && !this.title.equals(pg.title)) {
            return false;
        }
        this.currentAuthor = pg.currentAuthor;
        this.updated = pg.updated;
        this.content = pg.content;
        return true;
    }

    public static String serverPathFor(String group, String title) throws MalformedURLException {
        if (title == null) {
            return null;
        }
        return UrlUtils.buildUrl(false, group, Page.idFor(title));
    }

    public static String idFor(String title) {
        if (title == null) {
            return null;
        }
        return title.toLowerCase().replaceAll("[^-_a-zA-Z0-9]+", "-");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return String.format("Page [id=%s, title=%s, group=%s]", this.id, this.title, this.group);
    }
}

