/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.freeki.infra.route.anno.proc;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.commonjava.freeki.infra.route.Method;
import org.commonjava.freeki.infra.route.anno.Route;

public final class RoutingTemplateInfo {
    private final String packagename;
    private final String qualifiedClassname;
    private final String classname;
    private final String methodname;
    private final Method httpMethod;
    private final String httpPath;
    private final String httpContentType;

    public RoutingTemplateInfo(String packagename, String qualifiedClassname, String classname, String methodname, Route route) {
        this.packagename = packagename;
        this.qualifiedClassname = qualifiedClassname;
        this.classname = classname;
        this.methodname = methodname;
        this.httpMethod = route.method();
        this.httpPath = route.path();
        this.httpContentType = route.contentType();
    }

    public RoutingTemplateInfo(Element elem, Route route) {
        this.httpMethod = route.method();
        this.httpPath = route.path();
        this.httpContentType = route.contentType();
        ExecutableElement eelem = (ExecutableElement)elem;
        this.methodname = eelem.getSimpleName().toString();
        TypeElement cls = (TypeElement)eelem.getEnclosingElement();
        PackageElement pkg = (PackageElement)cls.getEnclosingElement();
        this.qualifiedClassname = cls.getQualifiedName().toString();
        this.classname = cls.getSimpleName().toString();
        this.packagename = pkg.getQualifiedName().toString();
    }

    public String getPackagename() {
        return this.packagename;
    }

    public String getQualifiedClassname() {
        return this.qualifiedClassname;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getMethodname() {
        return this.methodname;
    }

    public Method getHttpMethod() {
        return this.httpMethod;
    }

    public String getHttpPath() {
        return this.httpPath;
    }

    public String getHttpContentType() {
        return this.httpContentType;
    }
}

