/*
 * Decompiled with CFR 0.152.
 */
package org.vertx.java.core.http.impl;

import java.util.ArrayDeque;
import java.util.Queue;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.http.impl.ClientConnection;
import org.vertx.java.core.http.impl.HttpPool;
import org.vertx.java.core.impl.DefaultContext;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.logging.impl.LoggerFactory;

public abstract class StandardHttpConnectionPool
implements HttpPool {
    private static final Logger log = LoggerFactory.getLogger(StandardHttpConnectionPool.class);
    private final Queue<ClientConnection> available = new ArrayDeque<ClientConnection>();
    private int maxPoolSize = 1;
    private int connectionCount;
    private final Queue<Waiter> waiters = new ArrayDeque<Waiter>();

    @Override
    public void setMaxPoolSize(int maxConnections) {
        this.maxPoolSize = maxConnections;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized void report() {
        log.trace("available: " + this.available.size() + " connection count: " + this.connectionCount + " waiters: " + this.waiters.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getConnection(Handler<ClientConnection> handler, Handler<Throwable> connectExceptionHandler, DefaultContext context) {
        ClientConnection conn;
        boolean connect = false;
        StandardHttpConnectionPool standardHttpConnectionPool = this;
        synchronized (standardHttpConnectionPool) {
            conn = this.available.poll();
            if (conn != null) {
            } else if (this.connectionCount < this.maxPoolSize) {
                connect = true;
                ++this.connectionCount;
            } else {
                this.waiters.add(new Waiter(handler, connectExceptionHandler, context));
            }
        }
        if (conn != null) {
            handler.handle(conn);
        } else if (connect) {
            this.connect(handler, connectExceptionHandler, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed() {
        Waiter waiter;
        StandardHttpConnectionPool standardHttpConnectionPool = this;
        synchronized (standardHttpConnectionPool) {
            --this.connectionCount;
            if (this.connectionCount < this.maxPoolSize) {
                waiter = this.waiters.poll();
                if (waiter != null) {
                    ++this.connectionCount;
                }
            } else {
                waiter = null;
            }
        }
        if (waiter != null) {
            this.connect(waiter.handler, waiter.connectionExceptionHandler, waiter.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnConnection(final ClientConnection conn) {
        Waiter waiter;
        StandardHttpConnectionPool standardHttpConnectionPool = this;
        synchronized (standardHttpConnectionPool) {
            waiter = this.waiters.poll();
            if (waiter == null) {
                this.available.add(conn);
            }
        }
        if (waiter != null) {
            final Waiter w = waiter;
            w.context.runOnContext(new VoidHandler(){

                @Override
                public void handle() {
                    w.handler.handle(conn);
                }
            });
        }
    }

    @Override
    public void close() {
        this.available.clear();
        this.waiters.clear();
    }

    protected abstract void connect(Handler<ClientConnection> var1, Handler<Throwable> var2, DefaultContext var3);

    private class Waiter {
        final Handler<ClientConnection> handler;
        final Handler<Throwable> connectionExceptionHandler;
        final DefaultContext context;

        private Waiter(Handler<ClientConnection> handler, Handler<Throwable> connectionExceptionHandler, DefaultContext context) {
            this.handler = handler;
            this.connectionExceptionHandler = connectionExceptionHandler;
            this.context = context;
        }
    }
}

