/*
 * Decompiled with CFR 0.152.
 */
package org.codenarc.analyzer;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.codenarc.analyzer.AbstractSourceAnalyzer;
import org.codenarc.analyzer.AnalyzerException;
import org.codenarc.results.DirectoryResults;
import org.codenarc.results.FileResults;
import org.codenarc.results.Results;
import org.codenarc.ruleset.RuleSet;
import org.codenarc.source.SourceCode;
import org.codenarc.source.SourceFile;
import org.codenarc.util.PathUtil;
import org.codenarc.util.WildcardPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesystemSourceAnalyzer
extends AbstractSourceAnalyzer {
    private static final String SEP;
    private static final String DEFAULT_INCLUDES = "**/*.groovy";
    private static final Logger LOG;
    private String baseDirectory;
    private String includes;
    private String excludes;
    private WildcardPattern includesPattern;
    private WildcardPattern excludesPattern;
    private boolean failOnError;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public FilesystemSourceAnalyzer() {
        MetaClass metaClass;
        boolean bl;
        String string;
        this.includes = string = DEFAULT_INCLUDES;
        this.failOnError = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public Results analyze(RuleSet ruleSet) {
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = this.baseDirectory;
            valueRecorder.record((Object)string, 8);
            valueRecorder.record((Object)string, 8);
            if (IndyInterface.bootstrap("cast", "()", 0, string) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert baseDirectory", (ValueRecorder)valueRecorder), null);
            }
            valueRecorder.clear();
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            RuleSet ruleSet2 = ruleSet;
            valueRecorder2.record((Object)ruleSet2, 8);
            if (IndyInterface.bootstrap("cast", "()", 0, ruleSet2) == false) {
                throw InvokerHelper.createAssertError((Object)AssertionRenderer.render((String)"assert ruleSet", (ValueRecorder)valueRecorder2), null);
            }
            valueRecorder2.clear();
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        CallSite callSite = IndyInterface.bootstrap("invoke", "normalizePath", 0, PathUtil.class, this.baseDirectory);
        this.baseDirectory = IndyInterface.bootstrap("cast", "()", 0, callSite);
        IndyInterface.bootstrap("invoke", "initializeWildcardPatterns", 2, this);
        CallSite reportResults = IndyInterface.bootstrap("init", "<init>", 0, DirectoryResults.class);
        CallSite dirResults = IndyInterface.bootstrap("invoke", "processDirectory", 2, this, "", ruleSet);
        IndyInterface.bootstrap("invoke", "addChild", 0, reportResults, dirResults);
        return IndyInterface.bootstrap("cast", "()", 0, reportResults);
    }

    @Override
    public List getSourceDirectories() {
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{this.baseDirectory});
    }

    /*
     * WARNING - void declaration
     */
    private DirectoryResults processDirectory(String dir, RuleSet ruleSet) {
        void var2_2;
        Reference dir2 = new Reference((Object)dir);
        Reference ruleSet2 = new Reference((Object)var2_2);
        Reference dirResults = new Reference((Object)IndyInterface.bootstrap("init", "<init>", 0, DirectoryResults.class, (String)dir2.get()));
        CallSite dirFile = IndyInterface.bootstrap("init", "<init>", 0, File.class, this.baseDirectory, (String)dir2.get());
        public final class _processDirectory_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference dir;
            private /* synthetic */ Reference ruleSet;
            private /* synthetic */ Reference dirResults;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _processDirectory_closure1(Object _outerInstance, Object _thisObject, Reference dir, Reference ruleSet, Reference dirResults) {
                super(_outerInstance, _thisObject);
                Reference reference;
                Reference reference2;
                Reference reference3;
                this.dir = reference3 = dir;
                this.ruleSet = reference2 = ruleSet;
                this.dirResults = reference = dirResults;
            }

            public Object doCall(Object file) {
                CallSite dirPrefix = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, this.dir.get())) != false ? IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("cast", "()", 0, this.dir.get()), ScriptBytecodeAdapter.getField(_processDirectory_closure1.class, FilesystemSourceAnalyzer.class, (String)"SEP")) : IndyInterface.bootstrap("cast", "()", 0, this.dir.get());
                CallSite filePath = IndyInterface.bootstrap("invoke", "plus", 0, dirPrefix, IndyInterface.bootstrap("getProperty", "name", 0, file));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "directory", 0, file)) != false) {
                    CallSite subdirResults = IndyInterface.bootstrap("invoke", "processDirectory", 2, this, filePath, IndyInterface.bootstrap("cast", "()", 0, this.ruleSet.get()));
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTotalNumberOfFiles", 0, subdirResults, true)) != false) {
                        return IndyInterface.bootstrap("invoke", "addChild", 0, this.dirResults.get(), subdirResults);
                    }
                } else {
                    CallSite callSite = IndyInterface.bootstrap("invoke", "processFile", 2, this, filePath, this.dirResults.get(), IndyInterface.bootstrap("cast", "()", 0, this.ruleSet.get()));
                    try {
                        return callSite;
                    }
                    catch (Throwable t) {
                        IndyInterface.bootstrap("invoke", "warn", 0, ScriptBytecodeAdapter.getField(_processDirectory_closure1.class, FilesystemSourceAnalyzer.class, (String)"LOG"), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, "Error processing file: '", filePath), "'; "), t));
                        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "failOnError", 8, this)) != false) {
                            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AnalyzerException.class, new GStringImpl(new Object[]{filePath, t}, new String[]{"Error analyzing source file: ", "; ", ""})));
                        }
                    }
                }
                return null;
            }

            @Generated
            public String getDir() {
                return IndyInterface.bootstrap("cast", "()", 0, this.dir.get());
            }

            @Generated
            public RuleSet getRuleSet() {
                return IndyInterface.bootstrap("cast", "()", 0, this.ruleSet.get());
            }

            @Generated
            public Object getDirResults() {
                return this.dirResults.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _processDirectory_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "eachFile", 0, dirFile, new _processDirectory_closure1(this, this, dir2, ruleSet2, dirResults));
        return IndyInterface.bootstrap("cast", "()", 0, dirResults.get());
    }

    private void processFile(String filePath, DirectoryResults dirResults, RuleSet ruleSet) {
        CallSite file = IndyInterface.bootstrap("init", "<init>", 0, File.class, this.baseDirectory, filePath);
        CallSite sourceFile = IndyInterface.bootstrap("init", "<init>", 0, SourceFile.class, file);
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "matches", 2, this, sourceFile)) != false) {
            CallSite allViolations = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectViolations", 2, this, sourceFile, ruleSet));
            CallSite fileResults = IndyInterface.bootstrap("init", "<init>", 0, FileResults.class, filePath, allViolations, sourceFile);
            IndyInterface.bootstrap("invoke", "addChild", 0, dirResults, fileResults);
        }
    }

    protected boolean matches(SourceCode sourceFile) {
        CallSite path = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "path", 0, sourceFile));
        CallSite pathWithoutBaseDir = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "removeLeadingSlash", 0, PathUtil.class, IndyInterface.bootstrap("invoke", "minus", 0, path, this.baseDirectory)));
        boolean matchesIncludes = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "matches", 0, this.includesPattern, path)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "matches", 0, this.includesPattern, pathWithoutBaseDir));
        boolean matchesExcludes = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "matches", 0, this.excludesPattern, path)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "matches", 0, this.excludesPattern, pathWithoutBaseDir));
        return matchesIncludes && !matchesExcludes;
    }

    protected void initializeWildcardPatterns() {
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, WildcardPattern.class, this.includes);
        this.includesPattern = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("init", "<init>", 0, WildcardPattern.class, this.excludes, false);
        this.excludesPattern = IndyInterface.bootstrap("cast", "()", 0, callSite2);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FilesystemSourceAnalyzer.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    static {
        String string;
        SEP = string = "/";
        CallSite callSite = IndyInterface.bootstrap("invoke", "getLogger", 0, LoggerFactory.class, FilesystemSourceAnalyzer.class);
        LOG = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @Generated
    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    @Generated
    public void setBaseDirectory(String string) {
        this.baseDirectory = string;
    }

    @Generated
    public String getIncludes() {
        return this.includes;
    }

    @Generated
    public void setIncludes(String string) {
        this.includes = string;
    }

    @Generated
    public String getExcludes() {
        return this.excludes;
    }

    @Generated
    public void setExcludes(String string) {
        this.excludes = string;
    }

    @Generated
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public /* synthetic */ MetaClass super$2$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }
}

