/*
 * Decompiled with CFR 0.152.
 */
package org.codelibs.opensearch.runner;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codelibs.opensearch.runner.OpenSearchRunnerException;
import org.codelibs.opensearch.runner.node.OpenSearchRunnerNode;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.ParserProperties;
import org.opensearch.action.ActionResponse;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.opensearch.action.admin.indices.alias.get.GetAliasesRequestBuilder;
import org.opensearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.opensearch.action.admin.indices.close.CloseIndexRequestBuilder;
import org.opensearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.opensearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.opensearch.action.admin.indices.flush.FlushRequestBuilder;
import org.opensearch.action.admin.indices.flush.FlushResponse;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeRequestBuilder;
import org.opensearch.action.admin.indices.forcemerge.ForceMergeResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.opensearch.action.admin.indices.open.OpenIndexRequestBuilder;
import org.opensearch.action.admin.indices.open.OpenIndexResponse;
import org.opensearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.opensearch.action.admin.indices.refresh.RefreshResponse;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeRequestBuilder;
import org.opensearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.opensearch.action.delete.DeleteRequestBuilder;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.DefaultShardOperationFailedException;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.AdminClient;
import org.opensearch.client.Client;
import org.opensearch.client.Requests;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Priority;
import org.opensearch.common.Strings;
import org.opensearch.common.logging.LogConfigurator;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.env.Environment;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.node.InternalSettingsPreparer;
import org.opensearch.node.Node;
import org.opensearch.node.NodeValidationException;
import org.opensearch.plugins.Plugin;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.search.sort.SortBuilders;

public class OpenSearchRunner
implements Closeable {
    private static final Logger logger = LogManager.getLogger((String)"opensearch.runner");
    private static final String NODE_NAME = "node.name";
    protected static final String LOG4J2_PROPERTIES = "log4j2.properties";
    protected static final String ELASTICSEARCH_YAML = "opensearch.yml";
    protected static final String[] MODULE_TYPES = new String[]{"org.opensearch.search.aggregations.matrix.MatrixAggregationPlugin", "org.opensearch.analysis.common.CommonAnalysisPlugin", "org.opensearch.ingest.common.IngestCommonPlugin", "org.opensearch.ingest.useragent.IngestUserAgentPlugin", "org.opensearch.dashboards.OpenSearchDashboardsPlugin", "org.opensearch.script.expression.ExpressionPlugin", "org.opensearch.script.mustache.MustachePlugin", "org.opensearch.painless.PainlessPlugin", "org.opensearch.index.mapper.MapperExtrasPlugin", "org.opensearch.join.ParentJoinPlugin", "org.opensearch.percolator.PercolatorPlugin", "org.opensearch.index.rankeval.RankEvalPlugin", "org.opensearch.index.reindex.ReindexPlugin", "org.opensearch.plugin.repository.url.URLRepositoryPlugin", "org.opensearch.transport.Netty4Plugin"};
    protected static final String DATA_DIR = "data";
    protected static final String LOGS_DIR = "logs";
    protected static final String CONFIG_DIR = "config";
    protected List<OpenSearchRunnerNode> nodeList = new ArrayList<OpenSearchRunnerNode>();
    protected List<Environment> envList = new ArrayList<Environment>();
    protected Collection<Class<? extends Plugin>> moduleList = new ArrayList<Class<? extends Plugin>>();
    protected Collection<Class<? extends Plugin>> pluginList = new ArrayList<Class<? extends Plugin>>();
    protected int maxHttpPort = 9299;
    @Option(name="-basePath", usage="Base path for OpenSearch.")
    protected String basePath;
    @Option(name="-confPath", usage="Config path for OpenSearch.")
    protected String confPath;
    @Option(name="-dataPath", usage="Data path for OpenSearch.")
    protected String dataPath;
    @Option(name="-logsPath", usage="Log path for OpenSearch.")
    protected String logsPath;
    @Option(name="-numOfNode", usage="The number of OpenSearch node.")
    protected int numOfNode = 3;
    @Option(name="-baseHttpPort", usage="Base http port.")
    protected int baseHttpPort = 9200;
    @Option(name="-clusterName", usage="Cluster name.")
    protected String clusterName = "opensearch-runner";
    @Option(name="-indexStoreType", usage="Index store type.")
    protected String indexStoreType = "fs";
    @Option(name="-useLogger", usage="Print logs to a logger.")
    protected boolean useLogger = false;
    @Option(name="-disableESLogger", usage="Disable ESLogger.")
    protected boolean disableESLogger = false;
    @Option(name="-printOnFailure", usage="Print an exception on a failure.")
    protected boolean printOnFailure = false;
    @Option(name="-moduleTypes", usage="Module types.")
    protected String moduleTypes;
    @Option(name="-pluginTypes", usage="Plugin types.")
    protected String pluginTypes;
    protected Builder settingsBuilder;

    public static void main(String[] args) {
        try (final OpenSearchRunner runner = new OpenSearchRunner();){
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        runner.close();
                    }
                    catch (IOException e) {
                        runner.print(e.getLocalizedMessage());
                    }
                }
            });
            runner.build(args);
            while (!runner.isClosed()) {
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public boolean isClosed() {
        for (Node node : this.nodeList) {
            if (node.isClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        ArrayList<IOException> exceptionList = new ArrayList<IOException>();
        for (Node node : this.nodeList) {
            try {
                node.close();
                if (node.awaitClose(10L, TimeUnit.SECONDS)) continue;
                this.print("Failed to close node: " + node.settings().get(NODE_NAME, "unknown"));
            }
            catch (InterruptedException e) {
                logger.debug("Interupted closing process.", (Throwable)e);
            }
            catch (IOException e) {
                exceptionList.add(e);
            }
        }
        if (!exceptionList.isEmpty()) {
            if (this.useLogger && logger.isDebugEnabled()) {
                for (Exception exception : exceptionList) {
                    logger.debug("Failed to close a node.", (Throwable)exception);
                }
            }
            throw new IOException(((Object)exceptionList).toString());
        }
        this.print("Closed all nodes.");
    }

    public void clean() {
        LogManager.shutdown();
        Path bPath = FileSystems.getDefault().getPath(this.basePath, new String[0]);
        CleanUpFileVisitor visitor = new CleanUpFileVisitor();
        try {
            Files.walkFileTree(bPath, visitor);
            if (visitor.hasErrors()) {
                throw new OpenSearchRunnerException(visitor.getErrors().stream().map(Throwable::getLocalizedMessage).collect(Collectors.joining("\n")));
            }
        }
        catch (IOException e) {
            throw new OpenSearchRunnerException("Failed to delete " + bPath, e);
        }
    }

    public OpenSearchRunner onBuild(Builder builder) {
        this.settingsBuilder = builder;
        return this;
    }

    public void build(Configs configs) {
        this.build(configs.build());
    }

    public void build(String ... args) {
        String[] types;
        if (args != null) {
            CmdLineParser parser = new CmdLineParser((Object)this, ParserProperties.defaults().withUsageWidth(80));
            try {
                parser.parseArgument(args);
            }
            catch (CmdLineException e) {
                throw new OpenSearchRunnerException("Failed to parse args: " + Strings.arrayToDelimitedString((Object[])args, (String)" "));
            }
        }
        if (this.basePath == null) {
            try {
                this.basePath = Files.createTempDirectory("opensearch-cluster", new FileAttribute[0]).toAbsolutePath().toString();
            }
            catch (IOException e) {
                throw new OpenSearchRunnerException("Could not create $ES_HOME.", e);
            }
        }
        Path esBasePath = Paths.get(this.basePath, new String[0]);
        this.createDir(esBasePath);
        for (String moduleType : types = this.moduleTypes == null ? MODULE_TYPES : this.moduleTypes.split(",")) {
            try {
                Class<Plugin> clazz = Class.forName(moduleType).asSubclass(Plugin.class);
                this.moduleList.add(clazz);
            }
            catch (ClassNotFoundException e) {
                logger.debug("{} is not found.", (Object)moduleType, (Object)e);
            }
        }
        if (this.pluginTypes != null) {
            for (String value : this.pluginTypes.split(",")) {
                String pluginType = value.trim();
                if (pluginType.length() <= 0) continue;
                try {
                    Class<Plugin> clazz = Class.forName(pluginType).asSubclass(Plugin.class);
                    this.pluginList.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new OpenSearchRunnerException(pluginType + " is not found.", e);
                }
            }
        }
        this.print("Cluster Name: " + this.clusterName);
        this.print("Base Path:    " + this.basePath);
        this.print("Num Of Node:  " + this.numOfNode);
        for (int i = 0; i < this.numOfNode; ++i) {
            this.execute(i + 1);
        }
    }

    protected void execute(int id) {
        Path logConfPath;
        Path homePath = Paths.get(this.basePath, "node_" + id);
        Path confPath = this.confPath == null ? homePath.resolve(CONFIG_DIR) : Paths.get(this.confPath, new String[0]);
        Path logsPath = this.logsPath == null ? homePath.resolve(LOGS_DIR) : Paths.get(this.logsPath, new String[0]);
        Path dataPath = this.dataPath == null ? homePath.resolve(DATA_DIR) : Paths.get(this.dataPath, new String[0]);
        this.createDir(homePath);
        this.createDir(confPath);
        this.createDir(logsPath);
        this.createDir(dataPath);
        Settings.Builder builder = Settings.builder();
        if (this.settingsBuilder != null) {
            this.settingsBuilder.build(id, builder);
        }
        this.putIfAbsent(builder, "path.home", homePath.toAbsolutePath().toString());
        this.putIfAbsent(builder, "path.data", dataPath.toAbsolutePath().toString());
        this.putIfAbsent(builder, "path.logs", logsPath.toAbsolutePath().toString());
        Path esConfPath = confPath.resolve(ELASTICSEARCH_YAML);
        if (!esConfPath.toFile().exists()) {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/opensearch.yml");){
                Files.copy(is, esConfPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new OpenSearchRunnerException("Could not create: " + esConfPath, e);
            }
        }
        if (!this.disableESLogger && !(logConfPath = confPath.resolve(LOG4J2_PROPERTIES)).toFile().exists()) {
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("config/log4j2.properties");){
                Files.copy(is, logConfPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new OpenSearchRunnerException("Could not create: " + logConfPath, e);
            }
        }
        ArrayList<Class<? extends Plugin>> moduleAndPluginList = new ArrayList<Class<? extends Plugin>>();
        try {
            String modulePath = builder.get("path.modules");
            if (modulePath != null) {
                final Path sourcePath = Paths.get(modulePath, new String[0]);
                final Path targetPath = homePath.resolve("modules");
                Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }
                });
                builder.remove("path.modules");
            } else {
                moduleAndPluginList.addAll(this.moduleList);
            }
            moduleAndPluginList.addAll(this.pluginList);
            String pluginPath = builder.get("path.plugins");
            if (pluginPath != null) {
                final Path sourcePath = Paths.get(pluginPath, new String[0]);
                final Path targetPath = homePath.resolve("plugins");
                Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Files.createDirectories(targetPath.resolve(sourcePath.relativize(dir)), new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.copy(file, targetPath.resolve(sourcePath.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }
                });
                builder.remove("path.plugins");
            }
            String nodeName = "Node " + id;
            int httpPort = this.getAvailableHttpPort(id);
            this.putIfAbsent(builder, "cluster.name", this.clusterName);
            this.putIfAbsent(builder, NODE_NAME, nodeName);
            this.putIfAbsent(builder, "http.port", String.valueOf(httpPort));
            this.putIfAbsent(builder, "index.store.type", this.indexStoreType);
            if (!builder.keys().contains("node.roles")) {
                builder.putList("node.roles", new String[]{"cluster_manager", DATA_DIR});
            }
            this.print("Node Name:      " + nodeName);
            this.print("HTTP Port:      " + httpPort);
            this.print("Data Directory: " + dataPath);
            this.print("Log Directory:  " + logsPath);
            Settings settings = builder.build();
            Environment environment = InternalSettingsPreparer.prepareEnvironment((Settings)settings, Collections.emptyMap(), (Path)confPath, () -> nodeName);
            if (!this.disableESLogger) {
                LogConfigurator.registerErrorListener();
                LogConfigurator.configure((Environment)environment);
            }
            this.createDir(environment.modulesFile());
            this.createDir(environment.pluginsFile());
            OpenSearchRunnerNode node = new OpenSearchRunnerNode(environment, moduleAndPluginList);
            node.start();
            this.nodeList.add(node);
            this.envList.add(environment);
        }
        catch (Exception e) {
            throw new OpenSearchRunnerException("Failed to start node " + id, e);
        }
    }

    protected int getAvailableHttpPort(int number) {
        int httpPort = this.baseHttpPort + number;
        if (this.maxHttpPort < 0) {
            return httpPort;
        }
        while (httpPort <= this.maxHttpPort) {
            try (Socket socket = new Socket("localhost", httpPort);){
                ++httpPort;
            }
            catch (ConnectException e) {
                return httpPort;
            }
            catch (IOException e) {
                this.print(e.getMessage());
                ++httpPort;
            }
        }
        throw new OpenSearchRunnerException("The http port " + httpPort + " is unavailable.");
    }

    protected void putIfAbsent(Settings.Builder builder, String key, String value) {
        if (builder.get(key) == null && value != null) {
            builder.put(key, value);
        }
    }

    public void setMaxHttpPort(int maxHttpPort) {
        this.maxHttpPort = maxHttpPort;
    }

    public Node getNode(int i) {
        if (i < 0 || i >= this.nodeList.size()) {
            return null;
        }
        return this.nodeList.get(i);
    }

    public boolean startNode(int i) {
        if (i >= this.nodeList.size() || !this.nodeList.get(i).isClosed()) {
            return false;
        }
        OpenSearchRunnerNode node = new OpenSearchRunnerNode(this.envList.get(i), this.nodeList.get(i).getPlugins());
        try {
            node.start();
            this.nodeList.set(i, node);
            return true;
        }
        catch (NodeValidationException e) {
            this.print(e.getLocalizedMessage());
            return false;
        }
    }

    public Node getNode(String name) {
        if (name == null) {
            return null;
        }
        for (Node node : this.nodeList) {
            if (!name.equals(node.settings().get(NODE_NAME))) continue;
            return node;
        }
        return null;
    }

    public int getNodeIndex(Node node) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            if (!((Object)((Object)this.nodeList.get(i))).equals(node)) continue;
            return i;
        }
        return -1;
    }

    public int getNodeSize() {
        return this.nodeList.size();
    }

    public void print(String line) {
        if (this.useLogger) {
            logger.info(line);
        } else {
            System.out.println(line);
        }
    }

    protected void createDir(Path path) {
        if (!path.toFile().exists()) {
            this.print("Creating " + path);
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new OpenSearchRunnerException("Failed to create " + path, e);
            }
        }
    }

    public Node node() {
        for (Node node : this.nodeList) {
            if (node.isClosed()) continue;
            return node;
        }
        throw new OpenSearchRunnerException("All nodes are closed.");
    }

    public synchronized Node masterNode() {
        ClusterState state = ((ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet()).getState();
        String name = state.nodes().getMasterNode().getName();
        return this.getNode(name);
    }

    public synchronized Node nonMasterNode() {
        ClusterState state = ((ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet()).getState();
        String name = state.nodes().getMasterNode().getName();
        for (Node node : this.nodeList) {
            if (node.isClosed() || name.equals(node.settings().get(NODE_NAME))) continue;
            return node;
        }
        return null;
    }

    public Client client() {
        return this.node().client();
    }

    public AdminClient admin() {
        return this.client().admin();
    }

    public ClusterHealthStatus ensureGreen(String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).waitForGreenStatus().waitForEvents(Priority.LANGUID).waitForNoRelocatingShards(true)).actionGet();
        if (actionGet.isTimedOut()) {
            this.onFailure("ensureGreen timed out, cluster state:\n" + ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState() + "\n" + this.client().admin().cluster().preparePendingClusterTasks().get(), (ActionResponse)actionGet);
        }
        return actionGet.getStatus();
    }

    public ClusterHealthStatus ensureYellow(String ... indices) {
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(Requests.clusterHealthRequest((String[])indices).waitForNoRelocatingShards(true).waitForYellowStatus().waitForEvents(Priority.LANGUID)).actionGet();
        if (actionGet.isTimedOut()) {
            this.onFailure("ensureYellow timed out, cluster state:\n\n" + ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState() + "\n" + this.client().admin().cluster().preparePendingClusterTasks().get(), (ActionResponse)actionGet);
        }
        return actionGet.getStatus();
    }

    public ClusterHealthStatus waitForRelocation() {
        ClusterHealthRequest request = Requests.clusterHealthRequest((String[])new String[0]).waitForNoRelocatingShards(true);
        ClusterHealthResponse actionGet = (ClusterHealthResponse)this.client().admin().cluster().health(request).actionGet();
        if (actionGet.isTimedOut()) {
            this.onFailure("waitForRelocation timed out, cluster state:\n\n" + ((ClusterStateResponse)this.client().admin().cluster().prepareState().get()).getState() + "\n" + this.client().admin().cluster().preparePendingClusterTasks().get(), (ActionResponse)actionGet);
        }
        return actionGet.getStatus();
    }

    public FlushResponse flush() {
        return this.flush(true);
    }

    public FlushResponse flush(boolean force) {
        return this.flush(builder -> builder.setWaitIfOngoing(true).setForce(force));
    }

    public FlushResponse flush(BuilderCallback<FlushRequestBuilder> builder) {
        this.waitForRelocation();
        FlushResponse actionGet = (FlushResponse)builder.apply(this.client().admin().indices().prepareFlush(new String[0])).execute().actionGet();
        DefaultShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            StringBuilder buf = new StringBuilder(100);
            for (DefaultShardOperationFailedException shardFailure : shardFailures) {
                buf.append(shardFailure.toString()).append('\n');
            }
            this.onFailure(buf.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public RefreshResponse refresh() {
        return this.refresh(builder -> builder);
    }

    public RefreshResponse refresh(BuilderCallback<RefreshRequestBuilder> builder) {
        this.waitForRelocation();
        RefreshResponse actionGet = (RefreshResponse)builder.apply(this.client().admin().indices().prepareRefresh(new String[0])).execute().actionGet();
        DefaultShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            StringBuilder buf = new StringBuilder(100);
            for (DefaultShardOperationFailedException shardFailure : shardFailures) {
                buf.append(shardFailure.toString()).append('\n');
            }
            this.onFailure(buf.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public UpgradeResponse upgrade() {
        return this.upgrade(true);
    }

    public UpgradeResponse upgrade(boolean upgradeOnlyAncientSegments) {
        return this.upgrade(builder -> builder.setUpgradeOnlyAncientSegments(upgradeOnlyAncientSegments));
    }

    public UpgradeResponse upgrade(BuilderCallback<UpgradeRequestBuilder> builder) {
        this.waitForRelocation();
        UpgradeResponse actionGet = (UpgradeResponse)builder.apply(this.client().admin().indices().prepareUpgrade(new String[0])).execute().actionGet();
        DefaultShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            StringBuilder buf = new StringBuilder(100);
            for (DefaultShardOperationFailedException shardFailure : shardFailures) {
                buf.append(shardFailure.toString()).append('\n');
            }
            this.onFailure(buf.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public ForceMergeResponse forceMerge() {
        return this.forceMerge(-1, false, true);
    }

    public ForceMergeResponse forceMerge(int maxNumSegments, boolean onlyExpungeDeletes, boolean flush) {
        return this.forceMerge(builder -> builder.setMaxNumSegments(maxNumSegments).setOnlyExpungeDeletes(onlyExpungeDeletes).setFlush(flush));
    }

    public ForceMergeResponse forceMerge(BuilderCallback<ForceMergeRequestBuilder> builder) {
        this.waitForRelocation();
        ForceMergeResponse actionGet = (ForceMergeResponse)builder.apply(this.client().admin().indices().prepareForceMerge(new String[0])).execute().actionGet();
        DefaultShardOperationFailedException[] shardFailures = actionGet.getShardFailures();
        if (shardFailures != null && shardFailures.length != 0) {
            StringBuilder buf = new StringBuilder(100);
            for (DefaultShardOperationFailedException shardFailure : shardFailures) {
                buf.append(shardFailure.toString()).append('\n');
            }
            this.onFailure(buf.toString(), (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public OpenIndexResponse openIndex(String index) {
        return this.openIndex(index, builder -> builder);
    }

    public OpenIndexResponse openIndex(String index, BuilderCallback<OpenIndexRequestBuilder> builder) {
        OpenIndexResponse actionGet = (OpenIndexResponse)builder.apply(this.client().admin().indices().prepareOpen(new String[]{index})).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to open " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public AcknowledgedResponse closeIndex(String index) {
        return this.closeIndex(index, builder -> builder);
    }

    public AcknowledgedResponse closeIndex(String index, BuilderCallback<CloseIndexRequestBuilder> builder) {
        AcknowledgedResponse actionGet = (AcknowledgedResponse)builder.apply(this.client().admin().indices().prepareClose(new String[]{index})).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to close " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public CreateIndexResponse createIndex(String index, Settings settings) {
        return this.createIndex(index, (CreateIndexRequestBuilder builder) -> builder.setSettings(settings != null ? settings : Settings.Builder.EMPTY_SETTINGS));
    }

    public CreateIndexResponse createIndex(String index, BuilderCallback<CreateIndexRequestBuilder> builder) {
        CreateIndexResponse actionGet = (CreateIndexResponse)builder.apply(this.client().admin().indices().prepareCreate(index)).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public boolean indexExists(String index) {
        return this.indexExists(index, builder -> builder);
    }

    public boolean indexExists(String index, BuilderCallback<IndicesExistsRequestBuilder> builder) {
        IndicesExistsResponse actionGet = (IndicesExistsResponse)builder.apply(this.client().admin().indices().prepareExists(new String[]{index})).execute().actionGet();
        return actionGet.isExists();
    }

    public AcknowledgedResponse deleteIndex(String index) {
        return this.deleteIndex(index, builder -> builder);
    }

    public AcknowledgedResponse deleteIndex(String index, BuilderCallback<DeleteIndexRequestBuilder> builder) {
        AcknowledgedResponse actionGet = (AcknowledgedResponse)builder.apply(this.client().admin().indices().prepareDelete(new String[]{index})).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public AcknowledgedResponse createMapping(String index, String mappingSource) {
        return this.createMapping(index, (PutMappingRequestBuilder builder) -> builder.setSource(mappingSource, OpenSearchRunner.xContentType(mappingSource)));
    }

    public AcknowledgedResponse createMapping(String index, XContentBuilder source) {
        return this.createMapping(index, (PutMappingRequestBuilder builder) -> builder.setSource(source));
    }

    public AcknowledgedResponse createMapping(String index, BuilderCallback<PutMappingRequestBuilder> builder) {
        AcknowledgedResponse actionGet = (AcknowledgedResponse)builder.apply(this.client().admin().indices().preparePutMapping(new String[]{index})).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to create a mapping for " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public IndexResponse insert(String index, String id, String source) {
        return this.insert(index, id, (IndexRequestBuilder builder) -> (IndexRequestBuilder)builder.setSource(source, OpenSearchRunner.xContentType(source)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE));
    }

    public IndexResponse insert(String index, String id, BuilderCallback<IndexRequestBuilder> builder) {
        IndexResponse actionGet = (IndexResponse)builder.apply(((IndexRequestBuilder)this.client().prepareIndex().setIndex(index)).setId(id)).execute().actionGet();
        if (actionGet.getResult() != DocWriteResponse.Result.CREATED) {
            this.onFailure("Failed to insert " + id + " into " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public DeleteResponse delete(String index, String id) {
        return this.delete(index, id, builder -> (DeleteRequestBuilder)builder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE));
    }

    public DeleteResponse delete(String index, String id, BuilderCallback<DeleteRequestBuilder> builder) {
        DeleteResponse actionGet = (DeleteResponse)builder.apply(((DeleteRequestBuilder)this.client().prepareDelete().setIndex(index)).setId(id)).execute().actionGet();
        if (actionGet.getResult() != DocWriteResponse.Result.DELETED) {
            this.onFailure("Failed to delete " + id + " from " + index + ".", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public SearchResponse count(String index) {
        return this.count(index, builder -> builder);
    }

    public SearchResponse count(String index, BuilderCallback<SearchRequestBuilder> builder) {
        return (SearchResponse)builder.apply(this.client().prepareSearch(new String[]{index}).setSize(0)).execute().actionGet();
    }

    public SearchResponse search(String index, QueryBuilder queryBuilder, SortBuilder<?> sort, int from, int size) {
        return this.search(index, builder -> builder.setQuery((QueryBuilder)(queryBuilder != null ? queryBuilder : QueryBuilders.matchAllQuery())).addSort((SortBuilder)(sort != null ? sort : SortBuilders.scoreSort())).setFrom(from).setSize(size));
    }

    public SearchResponse search(String index, BuilderCallback<SearchRequestBuilder> builder) {
        return (SearchResponse)builder.apply(this.client().prepareSearch(new String[]{index})).execute().actionGet();
    }

    public GetAliasesResponse getAlias(String alias) {
        return this.getAlias(alias, builder -> builder);
    }

    public GetAliasesResponse getAlias(String alias, BuilderCallback<GetAliasesRequestBuilder> builder) {
        return (GetAliasesResponse)builder.apply(this.client().admin().indices().prepareGetAliases(new String[]{alias})).execute().actionGet();
    }

    public AcknowledgedResponse updateAlias(String alias, String[] addedIndices, String[] deletedIndices) {
        return this.updateAlias(builder -> {
            if (addedIndices != null && addedIndices.length > 0) {
                builder.addAlias(addedIndices, alias);
            }
            if (deletedIndices != null && deletedIndices.length > 0) {
                builder.removeAlias(deletedIndices, new String[]{alias});
            }
            return builder;
        });
    }

    public AcknowledgedResponse updateAlias(BuilderCallback<IndicesAliasesRequestBuilder> builder) {
        AcknowledgedResponse actionGet = (AcknowledgedResponse)builder.apply(this.client().admin().indices().prepareAliases()).execute().actionGet();
        if (!actionGet.isAcknowledged()) {
            this.onFailure("Failed to update aliases.", (ActionResponse)actionGet);
        }
        return actionGet;
    }

    public ClusterService clusterService() {
        return this.getInstance(ClusterService.class);
    }

    public synchronized <T> T getInstance(Class<T> clazz) {
        Node node = this.masterNode();
        return (T)node.injector().getInstance(clazz);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    private void onFailure(String message, ActionResponse response) {
        if (!this.printOnFailure) {
            throw new OpenSearchRunnerException(message, response);
        }
        this.print(message);
    }

    public static Configs newConfigs() {
        return new Configs();
    }

    private static XContentType xContentType(CharSequence content) {
        int length;
        int n = length = content.length() < 20 ? content.length() : 20;
        if (length == 0) {
            return null;
        }
        char first = content.charAt(0);
        if (first == '{') {
            return XContentType.JSON;
        }
        if (length > 2 && first == ':' && content.charAt(1) == ')' && content.charAt(2) == '\n') {
            return XContentType.SMILE;
        }
        if (length > 2 && first == '-' && content.charAt(1) == '-' && content.charAt(2) == '-') {
            return XContentType.YAML;
        }
        for (int i = 0; i < length; ++i) {
            char c = content.charAt(i);
            if (c == '{') {
                return XContentType.JSON;
            }
            if (!Character.isWhitespace(c)) break;
        }
        return null;
    }

    public static interface BuilderCallback<T> {
        public T apply(T var1);
    }

    public static class Configs {
        List<String> configList = new ArrayList<String>();

        public Configs basePath(String basePath) {
            this.configList.add("-basePath");
            this.configList.add(basePath);
            return this;
        }

        public Configs numOfNode(int numOfNode) {
            this.configList.add("-numOfNode");
            this.configList.add(String.valueOf(numOfNode));
            return this;
        }

        public Configs baseHttpPort(int baseHttpPort) {
            this.configList.add("-baseHttpPort");
            this.configList.add(String.valueOf(baseHttpPort));
            return this;
        }

        public Configs clusterName(String clusterName) {
            this.configList.add("-clusterName");
            this.configList.add(clusterName);
            return this;
        }

        public Configs indexStoreType(String indexStoreType) {
            this.configList.add("-indexStoreType");
            this.configList.add(indexStoreType);
            return this;
        }

        public Configs useLogger() {
            this.configList.add("-useLogger");
            return this;
        }

        public Configs disableESLogger() {
            this.configList.add("-disableESLogger");
            return this;
        }

        public Configs printOnFailure() {
            this.configList.add("-printOnFailure");
            return this;
        }

        public Configs moduleTypes(String moduleTypes) {
            this.configList.add("-moduleTypes");
            this.configList.add(moduleTypes);
            return this;
        }

        public Configs pluginTypes(String pluginTypes) {
            this.configList.add("-pluginTypes");
            this.configList.add(pluginTypes);
            return this;
        }

        public String[] build() {
            return this.configList.toArray(new String[this.configList.size()]);
        }
    }

    public static interface Builder {
        public void build(int var1, Settings.Builder var2);
    }

    private static final class CleanUpFileVisitor
    implements FileVisitor<Path> {
        private final List<Throwable> errorList = new ArrayList<Throwable>();

        private CleanUpFileVisitor() {
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        public boolean hasErrors() {
            return !this.errorList.isEmpty();
        }

        public List<Throwable> getErrors() {
            return this.errorList;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.delete(file);
            return this.checkIfExist(file);
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            throw exc;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            Files.delete(dir);
            if (dir.toFile().exists()) {
                this.errorList.add(new IOException("Failed to delete " + dir));
                dir.toFile().deleteOnExit();
            }
            return FileVisitResult.CONTINUE;
        }

        private FileVisitResult checkIfExist(Path path) {
            if (path.toFile().exists()) {
                this.errorList.add(new IOException("Failed to delete " + path));
                path.toFile().deleteOnExit();
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

