/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.jhighlight.pcj.map;

import com.uwyn.jhighlight.pcj.CharIterator;
import com.uwyn.jhighlight.pcj.hash.CharHashFunction;
import com.uwyn.jhighlight.pcj.hash.DefaultCharHashFunction;
import com.uwyn.jhighlight.pcj.hash.Primes;
import com.uwyn.jhighlight.pcj.map.AbstractCharKeyMap;
import com.uwyn.jhighlight.pcj.map.CharKeyMap;
import com.uwyn.jhighlight.pcj.map.CharKeyMapIterator;
import com.uwyn.jhighlight.pcj.set.AbstractCharSet;
import com.uwyn.jhighlight.pcj.set.CharSet;
import com.uwyn.jhighlight.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class CharKeyOpenHashMap
extends AbstractCharKeyMap
implements CharKeyMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private CharHashFunction keyhash;
    private int size;
    private transient char[] keys;
    private transient Object[] values;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient CharSet ckeys;
    private transient Collection cvalues;

    private CharKeyOpenHashMap(CharHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        capacity = Primes.nextPrime(capacity);
        this.keys = new char[capacity];
        this.values = new Object[capacity];
        this.states = new byte[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.used = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
    }

    private CharKeyOpenHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultCharHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public CharKeyOpenHashMap() {
        this(11);
    }

    public CharKeyOpenHashMap(CharKeyMap map) {
        this();
        this.putAll(map);
    }

    public CharKeyOpenHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public CharKeyOpenHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public CharKeyOpenHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public CharKeyOpenHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public CharKeyOpenHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public CharKeyOpenHashMap(CharHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.keys.length * (1.0 + this.growthFactor)) : this.keys.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            char[] newkeys = new char[newcapacity];
            Object[] newvalues = new Object[newcapacity];
            byte[] newstates = new byte[newcapacity];
            this.used = 0;
            for (int i = 0; i < this.keys.length; ++i) {
                if (this.states[i] != 1) continue;
                ++this.used;
                char k = this.keys[i];
                Object v = this.values[i];
                int h = Math.abs(this.keyhash.hash(k));
                int n = h % newcapacity;
                if (newstates[n] == 1) {
                    int c = 1 + h % (newcapacity - 2);
                    do {
                        if ((n -= c) >= 0) continue;
                        n += newcapacity;
                    } while (newstates[n] != 0);
                }
                newstates[n] = 1;
                newvalues[n] = v;
                newkeys[n] = k;
            }
            this.keys = newkeys;
            this.values = newvalues;
            this.states = newstates;
        }
    }

    @Override
    public CharSet keySet() {
        if (this.ckeys == null) {
            this.ckeys = new KeySet();
        }
        return this.ckeys;
    }

    @Override
    public Object put(char key, Object value) {
        int i;
        block5: {
            int h = Math.abs(this.keyhash.hash(key));
            i = h % this.keys.length;
            if (this.states[i] == 1) {
                if (this.keys[i] == key) {
                    Object oldValue = this.values[i];
                    this.values[i] = value;
                    return oldValue;
                }
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) < 0) {
                        i += this.keys.length;
                    }
                    if (this.states[i] == 0 || this.states[i] == 2) break block5;
                } while (this.states[i] != 1 || this.keys[i] != key);
                Object oldValue = this.values[i];
                this.values[i] = value;
                return oldValue;
            }
        }
        if (this.states[i] == 0) {
            ++this.used;
        }
        this.states[i] = 1;
        this.keys[i] = key;
        this.values[i] = value;
        ++this.size;
        this.ensureCapacity(this.used);
        return null;
    }

    @Override
    public Collection values() {
        if (this.cvalues == null) {
            this.cvalues = new ValueCollection();
        }
        return this.cvalues;
    }

    public Object clone() {
        try {
            CharKeyOpenHashMap c = (CharKeyOpenHashMap)super.clone();
            c.keys = new char[this.keys.length];
            System.arraycopy(this.keys, 0, c.keys, 0, this.keys.length);
            c.values = new Object[this.values.length];
            System.arraycopy(this.values, 0, c.values, 0, this.values.length);
            c.states = new byte[this.states.length];
            System.arraycopy(this.states, 0, c.states, 0, this.states.length);
            c.cvalues = null;
            c.ckeys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    @Override
    public CharKeyMapIterator entries() {
        return new CharKeyMapIterator(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int index) {
                while (index < CharKeyOpenHashMap.this.keys.length && CharKeyOpenHashMap.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry < CharKeyOpenHashMap.this.keys.length;
            }

            @Override
            public void next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
            }

            @Override
            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((CharKeyOpenHashMap)CharKeyOpenHashMap.this).states[this.lastEntry] = 2;
                ((CharKeyOpenHashMap)CharKeyOpenHashMap.this).values[this.lastEntry] = null;
                CharKeyOpenHashMap.this.size--;
                this.lastEntry = -1;
            }

            @Override
            public char getKey() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return CharKeyOpenHashMap.this.keys[this.lastEntry];
            }

            @Override
            public Object getValue() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return CharKeyOpenHashMap.this.values[this.lastEntry];
            }
        };
    }

    @Override
    public void clear() {
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
        this.used = 0;
    }

    @Override
    public boolean containsKey(char key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return true;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return false;
            } while (this.states[i] != 1 || this.keys[i] != key);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            for (int i = 0; i < this.states.length; ++i) {
                if (this.states[i] != 1 || this.values[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.states.length; ++i) {
                if (this.states[i] != 1 || !value.equals(this.values[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(char key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return null;
            } while (this.states[i] != 1 || this.keys[i] != key);
            return this.values[i];
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object remove(char key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                Object oldValue = this.values[i];
                this.values[i] = null;
                this.states[i] = 2;
                --this.size;
                return oldValue;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return null;
            } while (this.states[i] != 1 || this.keys[i] != key);
            Object oldValue = this.values[i];
            this.values[i] = null;
            this.states[i] = 2;
            --this.size;
            return oldValue;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.keys.length);
        CharKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeChar(i.getKey());
            s.writeObject(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keys = new char[s.readInt()];
        this.states = new byte[this.keys.length];
        this.values = new Object[this.keys.length];
        this.used = this.size;
        for (int n = 0; n < this.size; ++n) {
            char key = s.readChar();
            Object value = s.readObject();
            int h = Math.abs(this.keyhash.hash(key));
            int i = h % this.keys.length;
            if (this.states[i] != 0) {
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) >= 0) continue;
                    i += this.keys.length;
                } while (this.states[i] != 0);
            }
            this.states[i] = 1;
            this.keys[i] = key;
            this.values[i] = value;
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        @Override
        public void clear() {
            CharKeyOpenHashMap.this.clear();
        }

        @Override
        public boolean contains(Object v) {
            return CharKeyOpenHashMap.this.containsValue(v);
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                int nextEntry = this.nextEntry(0);
                int lastEntry = -1;

                int nextEntry(int index) {
                    while (index < CharKeyOpenHashMap.this.keys.length && CharKeyOpenHashMap.this.states[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                @Override
                public boolean hasNext() {
                    return this.nextEntry < CharKeyOpenHashMap.this.keys.length;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return CharKeyOpenHashMap.this.values[this.lastEntry];
                }

                @Override
                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    ((CharKeyOpenHashMap)CharKeyOpenHashMap.this).states[this.lastEntry] = 2;
                    ((CharKeyOpenHashMap)CharKeyOpenHashMap.this).values[this.lastEntry] = null;
                    CharKeyOpenHashMap.this.size--;
                    this.lastEntry = -1;
                }
            };
        }

        @Override
        public int size() {
            return CharKeyOpenHashMap.this.size;
        }
    }

    private class KeySet
    extends AbstractCharSet {
        private KeySet() {
        }

        @Override
        public void clear() {
            CharKeyOpenHashMap.this.clear();
        }

        @Override
        public boolean contains(char v) {
            return CharKeyOpenHashMap.this.containsKey(v);
        }

        @Override
        public CharIterator iterator() {
            return new CharIterator(){
                int nextEntry = this.nextEntry(0);
                int lastEntry = -1;

                int nextEntry(int index) {
                    while (index < CharKeyOpenHashMap.this.keys.length && CharKeyOpenHashMap.this.states[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                @Override
                public boolean hasNext() {
                    return this.nextEntry < CharKeyOpenHashMap.this.keys.length;
                }

                @Override
                public char next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return CharKeyOpenHashMap.this.keys[this.lastEntry];
                }

                @Override
                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    ((CharKeyOpenHashMap)CharKeyOpenHashMap.this).states[this.lastEntry] = 2;
                    ((CharKeyOpenHashMap)CharKeyOpenHashMap.this).values[this.lastEntry] = null;
                    CharKeyOpenHashMap.this.size--;
                    this.lastEntry = -1;
                }
            };
        }

        @Override
        public boolean remove(char v) {
            boolean result = CharKeyOpenHashMap.this.containsKey(v);
            if (result) {
                CharKeyOpenHashMap.this.remove(v);
            }
            return result;
        }

        @Override
        public int size() {
            return CharKeyOpenHashMap.this.size;
        }
    }
}

