/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.jhighlight.pcj;

import com.uwyn.jhighlight.pcj.CharCollection;
import com.uwyn.jhighlight.pcj.CharIterator;
import com.uwyn.jhighlight.pcj.util.Display;
import com.uwyn.jhighlight.pcj.util.Exceptions;

public abstract class AbstractCharCollection
implements CharCollection {
    protected AbstractCharCollection() {
    }

    @Override
    public boolean add(char v) {
        Exceptions.unsupported("add");
        return false;
    }

    @Override
    public boolean addAll(CharCollection c) {
        CharIterator i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            result |= this.add(i.next());
        }
        return result;
    }

    @Override
    public void clear() {
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    @Override
    public boolean contains(char v) {
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            if (i.next() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(CharCollection c) {
        CharIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(char v) {
        CharIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (i.next() != v) continue;
            i.remove();
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean removeAll(CharCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        CharIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(CharCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        CharIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    @Override
    public int size() {
        CharIterator i = this.iterator();
        int size = 0;
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    @Override
    public char[] toArray() {
        return this.toArray(null);
    }

    @Override
    public char[] toArray(char[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new char[size];
        }
        CharIterator i = this.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index] = i.next();
            ++index;
        }
        return a;
    }

    @Override
    public void trimToSize() {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            s.append(Display.display(i.next()));
        }
        s.append(']');
        return s.toString();
    }
}

