/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb1.dcerpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import jcifs.smb1.dcerpc.DcerpcException;
import jcifs.smb1.dcerpc.DcerpcHandle;
import jcifs.smb1.smb1.NtlmPasswordAuthentication;
import jcifs.smb1.smb1.SmbFileInputStream;
import jcifs.smb1.smb1.SmbFileOutputStream;
import jcifs.smb1.smb1.SmbNamedPipe;
import jcifs.smb1.util.Encdec;

public class DcerpcPipeHandle
extends DcerpcHandle {
    SmbNamedPipe pipe;
    SmbFileInputStream in = null;
    SmbFileOutputStream out = null;
    boolean isStart = true;

    public DcerpcPipeHandle(String url, NtlmPasswordAuthentication auth) throws UnknownHostException, MalformedURLException, DcerpcException {
        this.binding = DcerpcHandle.parseBinding(url);
        url = "smb1://" + this.binding.server + "/IPC$/" + this.binding.endpoint.substring(6);
        String params = "";
        String server = (String)this.binding.getOption("server");
        if (server != null) {
            params = params + "&server=" + server;
        }
        String address = (String)this.binding.getOption("address");
        if (server != null) {
            params = params + "&address=" + address;
        }
        if (params.length() > 0) {
            url = url + "?" + params.substring(1);
        }
        this.pipe = new SmbNamedPipe(url, 27198979, auth);
    }

    @Override
    protected void doSendFragment(byte[] buf, int off, int length, boolean isDirect) throws IOException {
        if (this.out != null && !this.out.isOpen()) {
            throw new IOException("DCERPC pipe is no longer open");
        }
        if (this.in == null) {
            this.in = (SmbFileInputStream)this.pipe.getNamedPipeInputStream();
        }
        if (this.out == null) {
            this.out = (SmbFileOutputStream)this.pipe.getNamedPipeOutputStream();
        }
        if (isDirect) {
            this.out.writeDirect(buf, off, length, 1);
            return;
        }
        this.out.write(buf, off, length);
    }

    @Override
    protected void doReceiveFragment(byte[] buf, boolean isDirect) throws IOException {
        if (buf.length < this.max_recv) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (buf[0] != 5 && buf[1] != 0) {
            throw new IOException("Unexpected DCERPC PDU header");
        }
        int flags = buf[3] & 0xFF;
        this.isStart = (flags & 2) == 2;
        short length = Encdec.dec_uint16le(buf, 8);
        if (length > this.max_recv) {
            throw new IOException("Unexpected fragment length: " + length);
        }
        for (int off = this.isStart && !isDirect ? this.in.read(buf, 0, 1024) : this.in.readDirect(buf, 0, buf.length); off < length; off += this.in.readDirect(buf, off, length - off)) {
        }
    }

    @Override
    public void close() throws IOException {
        this.state = 0;
        if (this.out != null) {
            this.out.close();
        }
    }
}

