/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicInteger;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.dcerpc.DcerpcBind;
import jcifs.dcerpc.DcerpcBinding;
import jcifs.dcerpc.DcerpcConstants;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcMessage;
import jcifs.dcerpc.DcerpcPipeHandle;
import jcifs.dcerpc.DcerpcSecurityProvider;
import jcifs.dcerpc.ndr.NdrBuffer;
import jcifs.dcerpc.ndr.NdrException;

public abstract class DcerpcHandle
implements DcerpcConstants,
AutoCloseable {
    private static final AtomicInteger call_id = new AtomicInteger(1);
    private final DcerpcBinding binding;
    private int max_xmit;
    private int max_recv;
    private int state;
    private DcerpcSecurityProvider securityProvider;
    private CIFSContext transportContext;

    protected static DcerpcBinding parseBinding(String str) throws DcerpcException {
        char[] arr = str.toCharArray();
        String proto = null;
        String key = null;
        DcerpcBinding binding = null;
        int si = 0;
        int mark = 0;
        int state = 0;
        block6: do {
            char ch = arr[si];
            switch (state) {
                case 0: {
                    if (ch != ':') continue block6;
                    proto = str.substring(mark, si);
                    mark = si + 1;
                    state = 1;
                    break;
                }
                case 1: {
                    if (ch == '\\') {
                        mark = si + 1;
                        break;
                    }
                    state = 2;
                }
                case 2: {
                    if (ch != '[') continue block6;
                    String server = str.substring(mark, si).trim();
                    if (server.length() == 0) {
                        server = "127.0.0.1";
                    }
                    binding = new DcerpcBinding(proto, str.substring(mark, si));
                    mark = si + 1;
                    state = 5;
                    break;
                }
                case 5: {
                    if (ch == '=') {
                        key = str.substring(mark, si).trim();
                        mark = si + 1;
                        break;
                    }
                    if (ch != ',' && ch != ']') continue block6;
                    String val = str.substring(mark, si).trim();
                    if (key == null) {
                        key = "endpoint";
                    }
                    if (binding != null) {
                        binding.setOption(key, val);
                    }
                    key = null;
                    break;
                }
                default: {
                    si = arr.length;
                }
            }
        } while (++si < arr.length);
        if (binding == null || binding.getEndpoint() == null) {
            throw new DcerpcException("Invalid binding URL: " + str);
        }
        return binding;
    }

    public DcerpcHandle(CIFSContext tc) {
        this.max_recv = this.max_xmit = 4280;
        this.state = 0;
        this.securityProvider = null;
        this.transportContext = tc;
        this.binding = null;
    }

    public DcerpcHandle(CIFSContext tc, DcerpcBinding binding) {
        this.max_recv = this.max_xmit = 4280;
        this.state = 0;
        this.securityProvider = null;
        this.transportContext = tc;
        this.binding = binding;
    }

    DcerpcBinding getBinding() {
        return this.binding;
    }

    int getMaxRecv() {
        return this.max_recv;
    }

    int getMaxXmit() {
        return this.max_xmit;
    }

    public static DcerpcHandle getHandle(String url, CIFSContext tc) throws MalformedURLException, DcerpcException {
        return DcerpcHandle.getHandle(url, tc, false);
    }

    public static DcerpcHandle getHandle(String url, CIFSContext tc, boolean unshared) throws MalformedURLException, DcerpcException {
        if (url.startsWith("ncacn_np:")) {
            return new DcerpcPipeHandle(url, tc, unshared);
        }
        throw new DcerpcException("DCERPC transport not supported: " + url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() throws DcerpcException, IOException {
        DcerpcHandle dcerpcHandle = this;
        synchronized (dcerpcHandle) {
            try {
                this.state = 1;
                DcerpcBind bind = new DcerpcBind(this.binding, this);
                this.sendrecv(bind);
            }
            catch (IOException ioe) {
                this.state = 0;
                throw ioe;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendrecv(DcerpcMessage msg) throws DcerpcException, IOException {
        if (this.state == 0) {
            this.bind();
        }
        byte[] inB = this.transportContext.getBufferCache().getBuffer();
        byte[] out = this.transportContext.getBufferCache().getBuffer();
        try {
            NdrBuffer buf = this.encodeMessage(msg, out);
            int off = this.sendFragments(msg, out, buf);
            int have = this.doSendReceiveFragment(out, off, msg.length, inB);
            if (have != 0) {
                this.setupReceivedFragment(buf);
                buf.setIndex(0);
                msg.decode_header(buf);
            }
            NdrBuffer msgBuf = have == 0 || !msg.isFlagSet(2) ? new NdrBuffer(this.receiveMoreFragments(msg, inB), 0) : new NdrBuffer(inB, 0);
            msg.decode(msgBuf);
        }
        finally {
            this.transportContext.getBufferCache().releaseBuffer(inB);
            this.transportContext.getBufferCache().releaseBuffer(out);
        }
        DcerpcException de = msg.getResult();
        if (de != null) {
            throw de;
        }
    }

    private int sendFragments(DcerpcMessage msg, byte[] out, NdrBuffer buf) throws IOException {
        int fragSize;
        int tot = buf.getLength() - 24;
        for (int off = 0; off < tot; off += fragSize) {
            fragSize = tot - off;
            if (24 + fragSize > this.max_xmit) {
                msg.flags &= 0xFFFFFFFD;
                fragSize = this.max_xmit - 24;
            } else {
                msg.flags |= 2;
                msg.alloc_hint = fragSize;
            }
            msg.length = 24 + fragSize;
            if (off > 0) {
                msg.flags &= 0xFFFFFFFE;
            }
            if ((msg.flags & 3) != 3) {
                buf.start = off;
                buf.reset();
                msg.encode_header(buf);
                buf.enc_ndr_long(msg.alloc_hint);
                buf.enc_ndr_short(0);
                buf.enc_ndr_short(msg.getOpnum());
            }
            if ((msg.flags & 2) != 2) {
                this.doSendFragment(out, off, msg.length);
                continue;
            }
            return off;
        }
        throw new IOException();
    }

    private byte[] receiveMoreFragments(DcerpcMessage msg, byte[] in) throws IOException, DcerpcException, NdrException {
        int off = 0;
        int len = msg.ptype == 2 ? msg.length : 24;
        byte[] fragBytes = new byte[this.max_recv];
        NdrBuffer fragBuf = new NdrBuffer(fragBytes, 0);
        while (!msg.isFlagSet(2)) {
            this.doReceiveFragment(fragBytes);
            this.setupReceivedFragment(fragBuf);
            fragBuf.reset();
            msg.decode_header(fragBuf);
            int stub_frag_len = msg.length - 24;
            if (off + stub_frag_len > in.length) {
                byte[] tmp = new byte[off + stub_frag_len];
                System.arraycopy(in, 0, tmp, 0, len);
                in = tmp;
            }
            System.arraycopy(fragBytes, 24, in, len, stub_frag_len);
            len += stub_frag_len;
        }
        return in;
    }

    private void setupReceivedFragment(NdrBuffer fbuf) throws DcerpcException {
        fbuf.reset();
        fbuf.setIndex(8);
        fbuf.setLength(fbuf.dec_ndr_short());
        if (this.securityProvider != null) {
            this.securityProvider.unwrap(fbuf);
        }
    }

    private NdrBuffer encodeMessage(DcerpcMessage msg, byte[] out) throws NdrException, DcerpcException {
        NdrBuffer buf = new NdrBuffer(out, 0);
        msg.flags = 3;
        msg.call_id = call_id.incrementAndGet();
        msg.encode(buf);
        if (this.securityProvider != null) {
            buf.setIndex(0);
            this.securityProvider.wrap(buf);
        }
        return buf;
    }

    public void setDcerpcSecurityProvider(DcerpcSecurityProvider securityProvider) {
        this.securityProvider = securityProvider;
    }

    public abstract String getServer();

    public abstract String getServerWithDfs();

    public abstract CIFSContext getTransportContext();

    public abstract byte[] getSessionKey() throws CIFSException;

    public String toString() {
        return this.binding.toString();
    }

    protected abstract void doSendFragment(byte[] var1, int var2, int var3) throws IOException;

    protected abstract int doReceiveFragment(byte[] var1) throws IOException;

    protected abstract int doSendReceiveFragment(byte[] var1, int var2, int var3, byte[] var4) throws IOException;

    @Override
    public void close() throws IOException {
        this.state = 0;
    }
}

