/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.util.StringTokenizer;
import jcifs.CIFSContext;
import jcifs.RuntimeCIFSException;
import jcifs.dcerpc.rpc;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.SmbException;
import jcifs.util.Encdec;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SID
extends rpc.sid_t
implements jcifs.SID {
    private static final Logger log = LoggerFactory.getLogger(SID.class);
    static final String[] SID_TYPE_NAMES = new String[]{"0", "User", "Domain group", "Domain", "Local group", "Builtin group", "Deleted", "Invalid", "Unknown"};
    public static final int SID_FLAG_RESOLVE_SIDS = 1;
    public static SID EVERYONE = null;
    public static SID CREATOR_OWNER = null;
    public static SID SYSTEM = null;
    int type;
    String domainName = null;
    String acctName = null;
    String origin_server = null;
    CIFSContext origin_ctx = null;

    public static byte[] toByteArray(rpc.sid_t sid) {
        byte[] dst = new byte[8 + sid.sub_authority_count * 4];
        int di = 0;
        dst[di++] = sid.revision;
        dst[di++] = sid.sub_authority_count;
        System.arraycopy(sid.identifier_authority, 0, dst, di, 6);
        di += 6;
        for (int ii = 0; ii < sid.sub_authority_count; ++ii) {
            Encdec.enc_uint32le(sid.sub_authority[ii], dst, di);
            di += 4;
        }
        return dst;
    }

    public SID(byte[] src, int si) {
        this.revision = src[si++];
        this.sub_authority_count = src[si++];
        this.identifier_authority = new byte[6];
        System.arraycopy(src, si, this.identifier_authority, 0, 6);
        si += 6;
        if (this.sub_authority_count > 100) {
            throw new RuntimeCIFSException("Invalid SID sub_authority_count");
        }
        this.sub_authority = new int[this.sub_authority_count];
        for (int i = 0; i < this.sub_authority_count; ++i) {
            this.sub_authority[i] = SMBUtil.readInt4(src, si);
            si += 4;
        }
    }

    public SID(String textual) throws SmbException {
        StringTokenizer st = new StringTokenizer(textual, "-");
        if (st.countTokens() < 3 || !st.nextToken().equals("S")) {
            throw new SmbException("Bad textual SID format: " + textual);
        }
        this.revision = Byte.parseByte(st.nextToken());
        String tmp = st.nextToken();
        long id = 0L;
        id = tmp.startsWith("0x") ? Long.parseLong(tmp.substring(2), 16) : Long.parseLong(tmp);
        this.identifier_authority = new byte[6];
        int i = 5;
        while (id > 0L) {
            this.identifier_authority[i] = (byte)(id % 256L);
            id >>= 8;
            --i;
        }
        this.sub_authority_count = (byte)st.countTokens();
        if (this.sub_authority_count > 0) {
            this.sub_authority = new int[this.sub_authority_count];
            for (i = 0; i < this.sub_authority_count; ++i) {
                this.sub_authority[i] = (int)(Long.parseLong(st.nextToken()) & 0xFFFFFFFFL);
            }
        }
    }

    public SID(SID domsid, int rid) {
        this.revision = domsid.revision;
        this.identifier_authority = domsid.identifier_authority;
        this.sub_authority_count = (byte)(domsid.sub_authority_count + 1);
        this.sub_authority = new int[this.sub_authority_count];
        for (int i = 0; i < domsid.sub_authority_count; ++i) {
            this.sub_authority[i] = domsid.sub_authority[i];
        }
        this.sub_authority[i] = rid;
    }

    public SID(SID domsid, SID id) {
        int i;
        this.revision = domsid.revision;
        this.identifier_authority = domsid.identifier_authority;
        this.sub_authority_count = (byte)(domsid.sub_authority_count + id.sub_authority_count);
        this.sub_authority = new int[this.sub_authority_count];
        for (i = 0; i < domsid.sub_authority_count; ++i) {
            this.sub_authority[i] = domsid.sub_authority[i];
        }
        for (i = domsid.sub_authority_count; i < domsid.sub_authority_count + id.sub_authority_count; ++i) {
            this.sub_authority[i] = id.sub_authority[i - domsid.sub_authority_count];
        }
    }

    public SID(rpc.sid_t sid, int type, String domainName, String acctName, boolean decrementAuthority) {
        this.revision = sid.revision;
        this.sub_authority_count = sid.sub_authority_count;
        this.identifier_authority = sid.identifier_authority;
        this.sub_authority = sid.sub_authority;
        this.type = type;
        this.domainName = domainName;
        this.acctName = acctName;
        if (decrementAuthority) {
            this.sub_authority_count = (byte)(this.sub_authority_count - 1);
            this.sub_authority = new int[this.sub_authority_count];
            for (int i = 0; i < this.sub_authority_count; ++i) {
                this.sub_authority[i] = sid.sub_authority[i];
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> t) {
        if (t.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new ClassCastException();
    }

    public byte[] toByteArray() {
        return SID.toByteArray(this);
    }

    public boolean isEmpty() {
        return this.sub_authority_count == 0;
    }

    public boolean isBlank() {
        boolean blank = true;
        for (int sub : this.sub_authority) {
            blank = blank && sub == 0;
        }
        return blank;
    }

    @Override
    public SID getDomainSid() {
        return new SID(this, 3, this.domainName, null, this.getType() != 3);
    }

    @Override
    public int getRid() {
        if (this.getType() == 3) {
            throw new IllegalArgumentException("This SID is a domain sid");
        }
        return this.sub_authority[this.sub_authority_count - 1];
    }

    @Override
    public int getType() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        return this.type;
    }

    @Override
    public String getTypeText() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        return SID_TYPE_NAMES[this.type];
    }

    @Override
    public String getDomainName() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.type == 8) {
            String full = this.toString();
            return full.substring(0, full.length() - this.getAccountName().length() - 1);
        }
        return this.domainName;
    }

    @Override
    public String getAccountName() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.type == 8) {
            return "" + this.sub_authority[this.sub_authority_count - 1];
        }
        if (this.type == 3) {
            return "";
        }
        return this.acctName;
    }

    public int hashCode() {
        int hcode = this.identifier_authority[5];
        for (int i = 0; i < this.sub_authority_count; ++i) {
            hcode += 65599 * this.sub_authority[i];
        }
        return hcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SID) {
            SID sid = (SID)obj;
            if (sid == this) {
                return true;
            }
            if (sid.sub_authority_count == this.sub_authority_count) {
                int i = this.sub_authority_count;
                while (i-- > 0) {
                    if (sid.sub_authority[i] == this.sub_authority[i]) continue;
                    return false;
                }
                for (i = 0; i < 6; ++i) {
                    if (sid.identifier_authority[i] == this.identifier_authority[i]) continue;
                    return false;
                }
                return sid.revision == this.revision;
            }
        }
        return false;
    }

    public String toString() {
        String ret = "S-" + (this.revision & 0xFF) + "-";
        if (this.identifier_authority[0] != 0 || this.identifier_authority[1] != 0) {
            ret = ret + "0x";
            ret = ret + Hexdump.toHexString(this.identifier_authority, 0, 6);
        } else {
            long shift = 0L;
            long id = 0L;
            for (int i = 5; i > 1; --i) {
                id += ((long)this.identifier_authority[i] & 0xFFL) << (int)shift;
                shift += 8L;
            }
            ret = ret + id;
        }
        for (int i = 0; i < this.sub_authority_count; ++i) {
            ret = ret + "-" + ((long)this.sub_authority[i] & 0xFFFFFFFFL);
        }
        return ret;
    }

    @Override
    public String toDisplayString() {
        if (this.origin_server != null) {
            this.resolveWeak();
        }
        if (this.domainName != null) {
            String str = this.type == 3 ? this.domainName : (this.type == 5 || this.domainName.equals("BUILTIN") ? (this.type == 8 ? this.toString() : this.acctName) : this.domainName + "\\" + this.acctName);
            return str;
        }
        return this.toString();
    }

    public void resolve(String authorityServerName, CIFSContext tc) throws IOException {
        jcifs.SID[] sids = new SID[]{this};
        tc.getSIDResolver().resolveSids(tc, authorityServerName, sids);
    }

    void resolveWeak() {
        if (this.origin_server != null) {
            try {
                this.resolve(this.origin_server, this.origin_ctx);
            }
            catch (IOException ioe) {
                log.debug("Failed to resolve SID", (Throwable)ioe);
            }
            finally {
                this.origin_server = null;
                this.origin_ctx = null;
            }
        }
    }

    public jcifs.SID[] getGroupMemberSids(String authorityServerName, CIFSContext tc, int flags) throws IOException {
        if (this.type != 2 && this.type != 4) {
            return new SID[0];
        }
        return tc.getSIDResolver().getGroupMemberSids(tc, authorityServerName, this.getDomainSid(), this.getRid(), flags);
    }

    public void initContext(String server, CIFSContext context) {
        this.origin_ctx = context;
        this.origin_server = server;
    }

    static {
        try {
            EVERYONE = new SID("S-1-1-0");
            CREATOR_OWNER = new SID("S-1-3-0");
            SYSTEM = new SID("S-1-5-18");
        }
        catch (SmbException se) {
            log.error("Failed to create builtin SIDs", (Throwable)se);
        }
    }
}

