/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

public class Hexdump {
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String toHexString(int val, int size) {
        char[] c = new char[size];
        Hexdump.toHexChars(val, c, 0, size);
        return new String(c);
    }

    public static String toHexString(long val, int size) {
        char[] c = new char[size];
        Hexdump.toHexChars(val, c, 0, size);
        return new String(c);
    }

    public static String toHexString(byte[] src, int srcIndex, int size) {
        char[] c = new char[2 * size];
        int j = 0;
        for (int i = 0; i < size; ++i) {
            c[j++] = HEX_DIGITS[src[srcIndex + i] >> 4 & 0xF];
            c[j++] = HEX_DIGITS[src[srcIndex + i] & 0xF];
        }
        return new String(c);
    }

    public static String toHexString(byte[] data) {
        return Hexdump.toHexString(data, 0, data.length);
    }

    public static void toHexChars(int val, char[] dst, int dstIndex, int size) {
        while (size > 0) {
            int i = dstIndex + size - 1;
            if (i < dst.length) {
                dst[i] = HEX_DIGITS[val & 0xF];
            }
            if (val != 0) {
                val >>>= 4;
            }
            --size;
        }
    }

    public static void toHexChars(long val, char[] dst, int dstIndex, int size) {
        while (size > 0) {
            dst[dstIndex + size - 1] = HEX_DIGITS[(int)(val & 0xFL)];
            if (val != 0L) {
                val >>>= 4;
            }
            --size;
        }
    }
}

