/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.notify;

import jcifs.CIFSContext;
import jcifs.Configuration;
import jcifs.internal.smb2.ServerMessageBlock2Request;
import jcifs.internal.smb2.notify.Smb2ChangeNotifyResponse;
import jcifs.internal.util.SMBUtil;

public class Smb2ChangeNotifyRequest
extends ServerMessageBlock2Request<Smb2ChangeNotifyResponse> {
    public static final int SMB2_WATCH_TREE = 1;
    public static final int FILE_NOTIFY_CHANGE_FILE_NAME = 1;
    public static final int FILE_NOTIFY_CHANGE_DIR_NAME = 2;
    public static final int FILE_NOTIFY_CHANGE_ATTRIBUTES = 4;
    public static final int FILE_NOTIFY_CHANGE_SIZE = 8;
    public static final int FILE_NOTIFY_CHANGE_LAST_WRITE = 16;
    public static final int FILE_NOTIFY_CHANGE_LAST_ACCESS = 32;
    public static final int FILE_NOTIFY_CHANGE_CREATION = 64;
    public static final int FILE_NOTIFY_CHANGE_EA = 128;
    public static final int FILE_NOTIFY_CHANGE_SECURITY = 256;
    public static final int FILE_NOTIFY_CHANGE_STREAM_NAME = 512;
    public static final int FILE_NOTIFY_CHANGE_STREAM_SIZE = 1024;
    public static final int FILE_NOTIFY_CHANGE_STREAM_WRITE = 2048;
    private final byte[] fileId;
    private int outputBufferLength;
    private int notifyFlags;
    private int completionFilter;

    public Smb2ChangeNotifyRequest(Configuration config, byte[] fileId) {
        super(config, 15);
        this.outputBufferLength = config.getNotifyBufferSize();
        this.fileId = fileId;
    }

    public void setNotifyFlags(int notifyFlags) {
        this.notifyFlags = notifyFlags;
    }

    public void setCompletionFilter(int completionFilter) {
        this.completionFilter = completionFilter;
    }

    @Override
    protected Smb2ChangeNotifyResponse createResponse(CIFSContext tc, ServerMessageBlock2Request<Smb2ChangeNotifyResponse> req) {
        return new Smb2ChangeNotifyResponse(tc.getConfig());
    }

    @Override
    public int size() {
        return Smb2ChangeNotifyRequest.size8(96);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SMBUtil.writeInt2(32L, dst, dstIndex);
        SMBUtil.writeInt2(this.notifyFlags, dst, dstIndex + 2);
        SMBUtil.writeInt4(this.outputBufferLength, dst, dstIndex += 4);
        System.arraycopy(this.fileId, 0, dst, dstIndex += 4, 16);
        SMBUtil.writeInt4(this.completionFilter, dst, dstIndex += 16);
        dstIndex += 4;
        return (dstIndex += 4) - start;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }
}

