/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.lock;

import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;

public class Smb2OplockBreakNotification
extends ServerMessageBlock2Response {
    private byte oplockLevel;
    private byte[] fileId;

    public Smb2OplockBreakNotification(Configuration config) {
        super(config);
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 24) {
            throw new SMBProtocolDecodingException("Expected structureSize = 24");
        }
        this.oplockLevel = buffer[bufferIndex + 2];
        bufferIndex += 4;
        this.fileId = new byte[16];
        System.arraycopy(buffer, bufferIndex += 4, this.fileId, 0, 16);
        return (bufferIndex += 16) - start;
    }

    @Override
    public String toString() {
        return "Smb2OpblockBreakNotification[oplockLevel=" + this.oplockLevel + ",fileId=" + Hexdump.toHexString(this.fileId) + "]";
    }
}

