/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.info;

import jcifs.CIFSException;
import jcifs.Configuration;
import jcifs.Decodable;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.dtyp.SecurityDescriptor;
import jcifs.internal.fscc.FileFsFullSizeInformation;
import jcifs.internal.fscc.FileFsSizeInformation;
import jcifs.internal.fscc.FileInternalInfo;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.util.SMBUtil;

public class Smb2QueryInfoResponse
extends ServerMessageBlock2Response {
    private byte expectInfoType;
    private byte expectInfoClass;
    private Decodable info;

    public Smb2QueryInfoResponse(Configuration config, byte expectInfoType, byte expectInfoClass) {
        super(config);
        this.expectInfoType = expectInfoType;
        this.expectInfoClass = expectInfoClass;
    }

    public Decodable getInfo() {
        return this.info;
    }

    public <T extends Decodable> T getInfo(Class<T> clazz) throws CIFSException {
        if (!clazz.isAssignableFrom(this.info.getClass())) {
            throw new CIFSException("Incompatible file information class");
        }
        return (T)this.getInfo();
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 9) {
            throw new SMBProtocolDecodingException("Expected structureSize = 9");
        }
        int bufferOffset = SMBUtil.readInt2(buffer, bufferIndex + 2) + this.getHeaderStart();
        int bufferLength = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        Decodable i = Smb2QueryInfoResponse.createInformation(this.expectInfoType, this.expectInfoClass);
        if (i != null) {
            i.decode(buffer, bufferOffset, bufferLength);
        }
        bufferIndex = Math.max(bufferIndex, bufferOffset + bufferLength);
        this.info = i;
        return bufferIndex - start;
    }

    private static Decodable createInformation(byte infoType, byte infoClass) throws SMBProtocolDecodingException {
        switch (infoType) {
            case 1: {
                return Smb2QueryInfoResponse.createFileInformation(infoClass);
            }
            case 2: {
                return Smb2QueryInfoResponse.createFilesystemInformation(infoClass);
            }
            case 4: {
                return Smb2QueryInfoResponse.createQuotaInformation(infoClass);
            }
            case 3: {
                return Smb2QueryInfoResponse.createSecurityInformation(infoClass);
            }
        }
        throw new SMBProtocolDecodingException("Unknwon information type " + infoType);
    }

    private static Decodable createFilesystemInformation(byte infoClass) throws SMBProtocolDecodingException {
        switch (infoClass) {
            case 7: {
                return new FileFsFullSizeInformation();
            }
            case 3: {
                return new FileFsSizeInformation();
            }
        }
        throw new SMBProtocolDecodingException("Unknown filesystem info class " + infoClass);
    }

    private static Decodable createSecurityInformation(byte infoClass) throws SMBProtocolDecodingException {
        return new SecurityDescriptor();
    }

    private static Decodable createQuotaInformation(byte infoClass) throws SMBProtocolDecodingException {
        switch (infoClass) {
            default: 
        }
        throw new SMBProtocolDecodingException("Unknown quota info class " + infoClass);
    }

    private static Decodable createFileInformation(byte infoClass) throws SMBProtocolDecodingException {
        switch (infoClass) {
            case 6: {
                return new FileInternalInfo();
            }
        }
        throw new SMBProtocolDecodingException("Unknown file info class " + infoClass);
    }
}

