/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.Address;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Config;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.http.NtlmSsp;
import jcifs.netbios.UniAddress;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import org.bouncycastle.util.encoders.Base64;

@Deprecated
public abstract class NtlmServlet
extends HttpServlet {
    private static final long serialVersionUID = -4686770199446333333L;
    private String defaultDomain;
    private String domainController;
    private boolean loadBalance;
    private boolean enableBasic;
    private boolean insecureBasic;
    private String realm;
    private CIFSContext transportContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Properties p = new Properties();
        p.putAll((Map<?, ?>)System.getProperties());
        p.setProperty("jcifs.smb.client.soTimeout", "300000");
        p.setProperty("jcifs.netbios.cachePolicy", "600");
        Enumeration e = config.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("jcifs.")) continue;
            p.setProperty(name, config.getInitParameter(name));
        }
        try {
            this.defaultDomain = p.getProperty("jcifs.smb.client.domain");
            this.domainController = p.getProperty("jcifs.http.domainController");
            if (this.domainController == null) {
                this.domainController = this.defaultDomain;
                this.loadBalance = Config.getBoolean(p, "jcifs.http.loadBalance", true);
            }
            this.enableBasic = Boolean.valueOf(p.getProperty("jcifs.http.enableBasic"));
            this.insecureBasic = Boolean.valueOf(p.getProperty("jcifs.http.insecureBasic"));
            this.realm = p.getProperty("jcifs.http.basicRealm");
            if (this.realm == null) {
                this.realm = "jCIFS";
            }
            this.transportContext = new BaseContext(new PropertyConfiguration(p));
        }
        catch (CIFSException ex) {
            throw new ServletException("Failed to initialize config", (Throwable)ex);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean offerBasic = this.enableBasic && (this.insecureBasic || request.isSecure());
        String msg = request.getHeader("Authorization");
        if (msg != null && (msg.startsWith("NTLM ") || offerBasic && msg.startsWith("Basic "))) {
            NtlmPasswordAuthentication ntlm;
            Address dc = this.loadBalance ? new UniAddress(this.getTransportContext().getNameServiceClient().getNbtByName(this.domainController, 28, null)) : this.getTransportContext().getNameServiceClient().getByName(this.domainController, true);
            if (msg.startsWith("NTLM ")) {
                byte[] challenge = this.getTransportContext().getTransportPool().getChallenge(this.getTransportContext(), dc);
                ntlm = NtlmSsp.authenticate(this.getTransportContext(), request, response, challenge);
                if (ntlm == null) {
                    return;
                }
            } else {
                String auth = new String(Base64.decode((String)msg.substring(6)), "US-ASCII");
                int index = auth.indexOf(58);
                String user = index != -1 ? auth.substring(0, index) : auth;
                String password = index != -1 ? auth.substring(index + 1) : "";
                index = user.indexOf(92);
                if (index == -1) {
                    index = user.indexOf(47);
                }
                String domain = index != -1 ? user.substring(0, index) : this.defaultDomain;
                user = index != -1 ? user.substring(index + 1) : user;
                ntlm = new NtlmPasswordAuthentication(this.getTransportContext(), domain, user, password);
            }
            try {
                this.getTransportContext().getTransportPool().logon(this.getTransportContext(), dc);
            }
            catch (SmbAuthException sae) {
                response.setHeader("WWW-Authenticate", "NTLM");
                if (offerBasic) {
                    response.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
                }
                response.setHeader("Connection", "close");
                response.setStatus(401);
                response.flushBuffer();
                return;
            }
            HttpSession ssn = request.getSession();
            ssn.setAttribute("NtlmHttpAuth", (Object)ntlm);
            ssn.setAttribute("ntlmdomain", (Object)ntlm.getUserDomain());
            ssn.setAttribute("ntlmuser", (Object)ntlm.getUsername());
        } else {
            HttpSession ssn = request.getSession(false);
            if (ssn == null || ssn.getAttribute("NtlmHttpAuth") == null) {
                response.setHeader("WWW-Authenticate", "NTLM");
                if (offerBasic) {
                    response.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
                }
                response.setStatus(401);
                response.flushBuffer();
                return;
            }
        }
        super.service(request, response);
    }

    private CIFSContext getTransportContext() {
        return this.transportContext;
    }
}

