/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb1.smb1;

import java.io.IOException;
import jcifs.smb1.smb1.SmbFileOutputStream;
import jcifs.smb1.smb1.SmbNamedPipe;
import jcifs.smb1.smb1.TransCallNamedPipe;
import jcifs.smb1.smb1.TransCallNamedPipeResponse;
import jcifs.smb1.smb1.TransTransactNamedPipe;
import jcifs.smb1.smb1.TransTransactNamedPipeResponse;
import jcifs.smb1.smb1.TransWaitNamedPipe;
import jcifs.smb1.smb1.TransWaitNamedPipeResponse;

class TransactNamedPipeOutputStream
extends SmbFileOutputStream {
    private String path;
    private SmbNamedPipe pipe;
    private byte[] tmp = new byte[1];
    private boolean dcePipe;

    TransactNamedPipeOutputStream(SmbNamedPipe pipe) throws IOException {
        super(pipe, false, pipe.pipeType & 0xFFFF00FF | 0x20);
        this.pipe = pipe;
        this.dcePipe = (pipe.pipeType & 0x600) == 1536;
        this.path = pipe.unc;
    }

    @Override
    public void close() throws IOException {
        this.pipe.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.tmp[0] = (byte)b;
        this.write(this.tmp, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            len = 0;
        }
        if ((this.pipe.pipeType & 0x100) == 256) {
            this.pipe.send(new TransWaitNamedPipe(this.path), new TransWaitNamedPipeResponse());
            this.pipe.send(new TransCallNamedPipe(this.path, b, off, len), new TransCallNamedPipeResponse(this.pipe));
        } else if ((this.pipe.pipeType & 0x200) == 512) {
            this.ensureOpen();
            TransTransactNamedPipe req = new TransTransactNamedPipe(this.pipe.fid, b, off, len);
            if (this.dcePipe) {
                req.maxDataCount = 1024;
            }
            this.pipe.send(req, new TransTransactNamedPipeResponse(this.pipe));
        }
    }
}

