/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import jcifs.CIFSException;
import jcifs.SmbPipeHandle;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.smb1.trans.TransCallNamedPipe;
import jcifs.internal.smb1.trans.TransCallNamedPipeResponse;
import jcifs.internal.smb1.trans.TransTransactNamedPipe;
import jcifs.internal.smb1.trans.TransTransactNamedPipeResponse;
import jcifs.internal.smb1.trans.TransWaitNamedPipe;
import jcifs.internal.smb1.trans.TransWaitNamedPipeResponse;
import jcifs.internal.smb2.ioctl.Smb2IoctlRequest;
import jcifs.internal.smb2.ioctl.Smb2IoctlResponse;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFileHandleImpl;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.SmbPipeHandleInternal;
import jcifs.smb.SmbPipeInputStream;
import jcifs.smb.SmbPipeOutputStream;
import jcifs.smb.SmbSessionImpl;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.util.ByteEncodable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbPipeHandleImpl
implements SmbPipeHandleInternal {
    private static final Logger log = LoggerFactory.getLogger(SmbPipeHandleImpl.class);
    private final SmbNamedPipe pipe;
    private final boolean transact;
    private final boolean call;
    private final int openFlags;
    private final int access;
    private volatile boolean open = true;
    private SmbFileHandleImpl handle;
    private SmbPipeOutputStream output;
    private SmbPipeInputStream input;
    private final String uncPath;
    private SmbTreeHandleImpl treeHandle;
    private int sharing = 7;

    public SmbPipeHandleImpl(SmbNamedPipe pipe) {
        this.pipe = pipe;
        this.transact = (pipe.getPipeType() & 0x200) == 512;
        this.call = (pipe.getPipeType() & 0x100) == 256;
        this.openFlags = pipe.getPipeType() & 0xFFFF00FF | 0x20;
        this.access = pipe.getPipeType() & 7 | 0x20000;
        this.uncPath = this.pipe.getUncPath();
    }

    @Override
    public <T extends SmbPipeHandle> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new ClassCastException();
    }

    @Override
    public SmbNamedPipe getPipe() {
        return this.pipe;
    }

    @Override
    public SmbTreeHandleImpl ensureTreeConnected() throws CIFSException {
        if (this.treeHandle == null) {
            this.treeHandle = this.pipe.ensureTreeConnected();
        }
        return this.treeHandle.acquire();
    }

    public String getUncPath() {
        return this.uncPath;
    }

    @Override
    public boolean isOpen() {
        return this.open && this.handle != null && this.handle.isValid();
    }

    @Override
    public byte[] getSessionKey() throws CIFSException {
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            SmbSessionImpl sess = th.getSession();
            try {
                byte[] byArray = sess.getSessionKey();
                if (sess != null) {
                    sess.close();
                }
                return byArray;
            }
            catch (Throwable throwable) {
                if (sess != null) {
                    try {
                        sess.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    @Override
    public boolean isStale() {
        return !this.open || this.handle != null && !this.handle.isValid();
    }

    @Override
    public synchronized SmbFileHandleImpl ensureOpen() throws CIFSException {
        if (!this.open) {
            throw new SmbException("Pipe handle already closed");
        }
        if (!this.isOpen()) {
            try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
                if (th.isSMB2()) {
                    this.handle = this.pipe.openUnshared(this.uncPath, 0, this.access, this.sharing, 128, 0);
                    SmbFileHandleImpl smbFileHandleImpl = this.handle.acquire();
                    return smbFileHandleImpl;
                }
                if (this.uncPath.startsWith("\\pipe\\")) {
                    th.send((CommonServerMessageBlockRequest)new TransWaitNamedPipe(th.getConfig(), this.uncPath), new TransWaitNamedPipeResponse(th.getConfig()), new RequestParam[0]);
                }
                this.handle = th.hasCapability(16) || this.uncPath.startsWith("\\pipe\\") ? this.pipe.openUnshared(this.openFlags, this.access, this.sharing, 128, 0) : this.pipe.openUnshared("\\pipe" + this.getUncPath(), this.openFlags, this.access, this.sharing, 128, 0);
                SmbFileHandleImpl smbFileHandleImpl = this.handle.acquire();
                return smbFileHandleImpl;
            }
        }
        log.trace("Pipe already open");
        return this.handle.acquire();
    }

    @Override
    public SmbPipeInputStream getInput() throws CIFSException {
        if (!this.open) {
            throw new SmbException("Already closed");
        }
        if (this.input != null) {
            return this.input;
        }
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            this.input = new SmbPipeInputStream(this, th);
        }
        return this.input;
    }

    @Override
    public SmbPipeOutputStream getOutput() throws CIFSException {
        if (!this.open) {
            throw new SmbException("Already closed");
        }
        if (this.output != null) {
            return this.output;
        }
        try (SmbTreeHandleImpl th = this.ensureTreeConnected();){
            this.output = new SmbPipeOutputStream(this, th);
        }
        return this.output;
    }

    @Override
    public int sendrecv(byte[] buf, int off, int length, byte[] inB, int maxRecvSize) throws IOException {
        try (SmbFileHandleImpl fh = this.ensureOpen();){
            SmbTreeHandleImpl th;
            block25: {
                block24: {
                    block23: {
                        th = fh.getTree();
                        try {
                            if (!th.isSMB2()) break block23;
                            Smb2IoctlRequest req = new Smb2IoctlRequest(th.getConfig(), 1163287, fh.getFileId(), inB);
                            req.setFlags(1);
                            req.setInputData(new ByteEncodable(buf, off, length));
                            req.setMaxOutputResponse(maxRecvSize);
                            Smb2IoctlResponse resp = th.send(req, RequestParam.NO_RETRY);
                            int n = resp.getOutputLength();
                            if (th != null) {
                                th.close();
                            }
                            return n;
                        }
                        catch (Throwable throwable) {
                            if (th != null) {
                                try {
                                    th.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (!this.transact) break block24;
                    TransTransactNamedPipe req = new TransTransactNamedPipe(th.getConfig(), fh.getFid(), buf, off, length);
                    TransTransactNamedPipeResponse resp2 = new TransTransactNamedPipeResponse(th.getConfig(), inB);
                    if ((this.getPipeType() & 0x600) == 1536) {
                        req.setMaxDataCount(1024);
                    }
                    th.send((CommonServerMessageBlockRequest)req, resp2, RequestParam.NO_RETRY);
                    int n = resp2.getResponseLength();
                    if (th != null) {
                        th.close();
                    }
                    return n;
                }
                if (!this.call) break block25;
                th.send((CommonServerMessageBlockRequest)new TransWaitNamedPipe(th.getConfig(), this.uncPath), new TransWaitNamedPipeResponse(th.getConfig()), new RequestParam[0]);
                TransCallNamedPipeResponse resp = new TransCallNamedPipeResponse(th.getConfig(), inB);
                th.send((CommonServerMessageBlockRequest)new TransCallNamedPipe(th.getConfig(), this.uncPath, buf, off, length), resp, new RequestParam[0]);
                int resp2 = resp.getResponseLength();
                if (th != null) {
                    th.close();
                }
                return resp2;
            }
            SmbPipeOutputStream out = this.getOutput();
            SmbPipeInputStream in = this.getInput();
            out.write(buf, off, length);
            int n = in.read(inB);
            if (th != null) {
                th.close();
            }
            return n;
        }
    }

    @Override
    public int recv(byte[] buf, int off, int len) throws IOException {
        return this.getInput().readDirect(buf, off, len);
    }

    @Override
    public void send(byte[] buf, int off, int length) throws IOException {
        this.getOutput().writeDirect(buf, off, length, 1);
    }

    @Override
    public int getPipeType() {
        return this.pipe.getPipeType();
    }

    @Override
    public synchronized void close() throws CIFSException {
        boolean wasOpen = this.isOpen();
        this.open = false;
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
        try {
            if (wasOpen) {
                this.handle.close();
            } else if (this.handle != null) {
                this.handle.release();
            }
            this.handle = null;
        }
        finally {
            if (this.treeHandle != null) {
                this.treeHandle.release();
            }
        }
    }
}

