/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import jcifs.CIFSContext;
import jcifs.netbios.Name;
import jcifs.netbios.NbtAddress;
import jcifs.smb.SmbFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lmhosts {
    private static final Logger log = LoggerFactory.getLogger(Lmhosts.class);
    private final Map<Name, NbtAddress> table = new HashMap<Name, NbtAddress>();
    private long lastModified = 1L;
    private int alt;

    public synchronized NbtAddress getByName(String host, CIFSContext tc) {
        return this.getByName(new Name(tc.getConfig(), host, 32, null), tc);
    }

    synchronized NbtAddress getByName(Name name, CIFSContext tc) {
        NbtAddress result;
        block9: {
            result = null;
            try {
                if (tc.getConfig().getLmHostsFileName() == null) break block9;
                File f = new File(tc.getConfig().getLmHostsFileName());
                long lm = f.lastModified();
                if (lm > this.lastModified) {
                    if (log.isDebugEnabled()) {
                        log.debug("Reading " + tc.getConfig().getLmHostsFileName());
                    }
                    this.lastModified = lm;
                    this.table.clear();
                    try (FileReader r = new FileReader(f);){
                        this.populate(r, tc);
                    }
                }
                result = this.table.get(name);
            }
            catch (IOException fnfe) {
                log.error("Could not read lmhosts " + tc.getConfig().getLmHostsFileName(), (Throwable)fnfe);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void populate(Reader r, CIFSContext tc) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(r);
        while ((line = br.readLine()) != null) {
            int j;
            int i;
            if ((line = line.toUpperCase().trim()).length() == 0) continue;
            if (line.charAt(0) == '#') {
                if (line.startsWith("#INCLUDE ")) {
                    line = line.substring(line.indexOf(92));
                    String url = "smb:" + line.replace('\\', '/');
                    InputStreamReader rdr = new InputStreamReader(new SmbFileInputStream(url, tc));
                    if (this.alt > 0) {
                        try {
                            this.populate(rdr, tc);
                        }
                        catch (IOException ioe) {
                            log.error("Failed to read include " + url, (Throwable)ioe);
                            rdr.close();
                            continue;
                        }
                        while ((line = br.readLine()) != null && !(line = line.toUpperCase().trim()).startsWith("#END_ALTERNATE")) {
                        }
                        continue;
                    }
                    this.populate(rdr, tc);
                    continue;
                }
                if (line.startsWith("#BEGIN_ALTERNATE") || !line.startsWith("#END_ALTERNATE") || this.alt <= 0) continue;
                throw new IOException("no lmhosts alternate includes loaded");
            }
            if (!Character.isDigit(line.charAt(0))) continue;
            char[] data = line.toCharArray();
            int c = 46;
            int ip = 0;
            for (i = 0; i < data.length && c == 46; ++i) {
                int b = 0;
                while (i < data.length && (c = data[i]) >= 48 && c <= 57) {
                    b = b * 10 + c - 48;
                    ++i;
                }
                ip = (ip << 8) + b;
            }
            while (i < data.length && Character.isWhitespace(data[i])) {
                ++i;
            }
            for (j = i; j < data.length && !Character.isWhitespace(data[j]); ++j) {
            }
            Name name = new Name(tc.getConfig(), line.substring(i, j), 32, null);
            NbtAddress addr = new NbtAddress(name, ip, false, 0, false, false, true, true, NbtAddress.UNKNOWN_MAC_ADDRESS);
            if (log.isDebugEnabled()) {
                log.debug("Adding " + name + " with addr " + addr);
            }
            this.table.put(name, addr);
        }
    }
}

