/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.create;

import java.util.LinkedList;
import jcifs.Configuration;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.SmbBasicFileInfo;
import jcifs.internal.smb2.RequestWithFileId;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.smb2.create.CreateContextResponse;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Smb2CreateResponse
extends ServerMessageBlock2Response
implements SmbBasicFileInfo {
    private static final Logger log = LoggerFactory.getLogger(Smb2CreateResponse.class);
    private byte oplockLevel;
    private byte openFlags;
    private int createAction;
    private long creationTime;
    private long lastAccessTime;
    private long lastWriteTime;
    private long changeTime;
    private long allocationSize;
    private long endOfFile;
    private int fileAttributes;
    private byte[] fileId = new byte[16];
    private CreateContextResponse[] createContexts;
    private final String fileName;

    public Smb2CreateResponse(Configuration config, String name) {
        super(config);
        this.fileName = name;
    }

    @Override
    public void prepare(CommonServerMessageBlockRequest next) {
        if (this.isReceived() && next instanceof RequestWithFileId) {
            ((RequestWithFileId)((Object)next)).setFileId(this.fileId);
        }
        super.prepare(next);
    }

    public final byte getOplockLevel() {
        return this.oplockLevel;
    }

    public final byte getOpenFlags() {
        return this.openFlags;
    }

    public final int getCreateAction() {
        return this.createAction;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public final long getCreateTime() {
        return this.getCreationTime();
    }

    @Override
    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    public final long getChangeTime() {
        return this.changeTime;
    }

    public final long getAllocationSize() {
        return this.allocationSize;
    }

    public final long getEndOfFile() {
        return this.endOfFile;
    }

    @Override
    public final long getSize() {
        return this.getEndOfFile();
    }

    public final int getFileAttributes() {
        return this.fileAttributes;
    }

    @Override
    public final int getAttributes() {
        return this.getFileAttributes();
    }

    public final byte[] getFileId() {
        return this.fileId;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public CreateContextResponse[] getCreateContexts() {
        return this.createContexts;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 89) {
            throw new SMBProtocolDecodingException("Structure size is not 89");
        }
        this.oplockLevel = buffer[bufferIndex + 2];
        this.openFlags = buffer[bufferIndex + 3];
        this.createAction = SMBUtil.readInt4(buffer, bufferIndex += 4);
        this.creationTime = SMBUtil.readTime(buffer, bufferIndex += 4);
        this.lastAccessTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.lastWriteTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.changeTime = SMBUtil.readTime(buffer, bufferIndex += 8);
        this.allocationSize = SMBUtil.readInt8(buffer, bufferIndex += 8);
        this.endOfFile = SMBUtil.readInt8(buffer, bufferIndex += 8);
        this.fileAttributes = SMBUtil.readInt4(buffer, bufferIndex += 8);
        bufferIndex += 4;
        System.arraycopy(buffer, bufferIndex += 4, this.fileId, 0, 16);
        int createContextOffset = SMBUtil.readInt4(buffer, bufferIndex += 16);
        int createContextLength = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        if (createContextOffset > 0 && createContextLength > 0) {
            LinkedList<CreateContextResponse> contexts = new LinkedList<CreateContextResponse>();
            int createContextStart = this.getHeaderStart() + createContextOffset;
            int next = 0;
            do {
                int cci = createContextStart;
                next = SMBUtil.readInt4(buffer, cci);
                int nameOffset = SMBUtil.readInt2(buffer, cci += 4);
                int nameLength = SMBUtil.readInt2(buffer, cci + 2);
                int dataOffset = SMBUtil.readInt2(buffer, (cci += 4) + 2);
                int dataLength = SMBUtil.readInt4(buffer, cci += 4);
                cci += 4;
                byte[] nameBytes = new byte[nameLength];
                System.arraycopy(buffer, createContextStart + nameOffset, nameBytes, 0, nameBytes.length);
                cci = Math.max(cci, createContextStart + nameOffset + nameLength);
                CreateContextResponse cc = Smb2CreateResponse.createContext(nameBytes);
                if (cc != null) {
                    cc.decode(buffer, createContextStart + dataOffset, dataLength);
                    contexts.add(cc);
                }
                cci = Math.max(cci, createContextStart + dataOffset + dataLength);
                if (next > 0) {
                    createContextStart += next;
                }
                bufferIndex = Math.max(bufferIndex, cci);
            } while (next > 0);
            this.createContexts = contexts.toArray(new CreateContextResponse[0]);
        }
        if (log.isDebugEnabled()) {
            log.debug("Opened " + this.fileName + ": " + Hexdump.toHexString(this.fileId));
        }
        return bufferIndex - start;
    }

    private static CreateContextResponse createContext(byte[] nameBytes) {
        return null;
    }
}

