/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileHandleImpl;
import jcifs.smb.SmbNamedPipe;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.smb.SmbTreeHandleInternal;
import jcifs.util.transport.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmbFileInputStream
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(SmbFileInputStream.class);
    private SmbFileHandleImpl handle;
    private long fp;
    private int readSize;
    private int readSizeFile;
    private int openFlags;
    private int access;
    private byte[] tmp = new byte[1];
    SmbFile file;
    private boolean largeReadX;
    private final boolean unsharedFile;
    private boolean smb2;

    public SmbFileInputStream(String url, CIFSContext tc) throws SmbException, MalformedURLException {
        this(new SmbFile(url, tc), 0, 1, 7, true);
    }

    public SmbFileInputStream(SmbFile file) throws SmbException {
        this(file, 0, 1, 7, false);
    }

    SmbFileInputStream(SmbFile file, int openFlags, int access, int sharing, boolean unshared) throws SmbException {
        this.file = file;
        this.unsharedFile = unshared;
        this.openFlags = openFlags;
        this.access = access;
        try (SmbTreeHandleImpl th = file.ensureTreeConnected();){
            this.smb2 = th.isSMB2();
            if (file.getType() != 16) {
                SmbFileHandleImpl h = this.ensureOpen();
                Throwable throwable = null;
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        h.close();
                    }
                }
                this.openFlags &= 0xFFFFFFAF;
            }
            this.init(th);
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    SmbFileInputStream(SmbFile file, SmbTreeHandleImpl th, SmbFileHandleImpl fh) throws SmbException {
        this.file = file;
        this.handle = fh;
        this.unsharedFile = false;
        this.smb2 = th.isSMB2();
        try {
            this.init(th);
        }
        catch (CIFSException e) {
            throw SmbException.wrap(e);
        }
    }

    private void init(SmbTreeHandleInternal th) throws CIFSException {
        if (this.smb2) {
            this.readSize = th.getReceiveBufferSize();
            this.readSizeFile = th.getReceiveBufferSize();
            return;
        }
        this.readSize = Math.min(th.getReceiveBufferSize() - 70, th.getMaximumBufferSize() - 70);
        if (th.hasCapability(16384)) {
            this.largeReadX = true;
            this.readSizeFile = Math.min(th.getConfig().getReceiveBufferSize() - 70, th.areSignaturesActive() ? 65465 : 0xFFFFB9);
            log.debug("Enabling LARGE_READX with " + this.readSizeFile);
        } else {
            log.debug("LARGE_READX disabled");
            this.readSizeFile = this.readSize;
        }
        if (log.isDebugEnabled()) {
            log.debug("Negotiated file read size is " + this.readSizeFile);
        }
    }

    synchronized SmbFileHandleImpl ensureOpen() throws CIFSException {
        if (this.handle == null || !this.handle.isValid()) {
            this.handle = this.file instanceof SmbNamedPipe ? this.file.openUnshared(32, ((SmbNamedPipe)this.file).getPipeType() & 0xFF0000, 3, 128, 0) : this.file.openUnshared(this.openFlags, this.access, 3, 128, 0).acquire();
            return this.handle;
        }
        return this.handle.acquire();
    }

    protected static IOException seToIoe(SmbException se) {
        IOException ioe = se;
        Throwable root = se.getCause();
        if (root instanceof TransportException) {
            ioe = (TransportException)root;
            root = ((TransportException)ioe).getCause();
        }
        if (root instanceof InterruptedException) {
            ioe = new InterruptedIOException(root.getMessage());
            ioe.initCause(root);
        }
        return ioe;
    }

    @Override
    public void close() throws IOException {
        try {
            SmbFileHandleImpl h = this.handle;
            if (h != null) {
                h.close();
            }
        }
        catch (SmbException se) {
            throw SmbFileInputStream.seToIoe(se);
        }
        finally {
            this.tmp = null;
            this.handle = null;
            if (this.unsharedFile) {
                this.file.close();
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.read(this.tmp, 0, 1) == -1) {
            return -1;
        }
        return this.tmp[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.readDirect(b, off, len);
    }

    /*
     * Exception decompiling
     */
    public int readDirect(byte[] b, int off, int len) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > 0L) {
            this.fp += n;
            return n;
        }
        return 0L;
    }
}

