/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.com;

import java.util.Date;
import jcifs.Configuration;
import jcifs.internal.SmbBasicFileInfo;
import jcifs.internal.smb1.ServerMessageBlock;
import jcifs.internal.util.SMBUtil;
import jcifs.util.Hexdump;

public class SmbComQueryInformationResponse
extends ServerMessageBlock
implements SmbBasicFileInfo {
    private int fileAttributes = 0;
    private long lastWriteTime = 0L;
    private long serverTimeZoneOffset;
    private int fileSize = 0;

    public SmbComQueryInformationResponse(Configuration config, long serverTimeZoneOffset) {
        super(config, (byte)8);
        this.serverTimeZoneOffset = serverTimeZoneOffset;
    }

    @Override
    public int getAttributes() {
        return this.fileAttributes;
    }

    @Override
    public long getCreateTime() {
        return this.convertTime(this.lastWriteTime);
    }

    private long convertTime(long time) {
        return time + this.serverTimeZoneOffset;
    }

    @Override
    public long getLastWriteTime() {
        return this.convertTime(this.lastWriteTime);
    }

    @Override
    public long getLastAccessTime() {
        return this.convertTime(this.lastWriteTime);
    }

    @Override
    public long getSize() {
        return this.fileSize;
    }

    @Override
    protected int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        if (this.wordCount == 0) {
            return 0;
        }
        this.fileAttributes = SMBUtil.readInt2(buffer, bufferIndex);
        this.lastWriteTime = SMBUtil.readUTime(buffer, bufferIndex += 2);
        this.fileSize = SMBUtil.readInt4(buffer, bufferIndex += 4);
        return 20;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("SmbComQueryInformationResponse[" + super.toString() + ",fileAttributes=0x" + Hexdump.toHexString(this.fileAttributes, 4) + ",lastWriteTime=" + new Date(this.lastWriteTime) + ",fileSize=" + this.fileSize + "]");
    }
}

