/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb2.info;

import java.util.ArrayList;
import jcifs.Configuration;
import jcifs.internal.SMBProtocolDecodingException;
import jcifs.internal.fscc.FileBothDirectoryInfo;
import jcifs.internal.smb2.ServerMessageBlock2Response;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.FileEntry;

public class Smb2QueryDirectoryResponse
extends ServerMessageBlock2Response {
    public static final int OVERHEAD = 72;
    private final byte expectInfoClass;
    private FileEntry[] results;

    public Smb2QueryDirectoryResponse(Configuration config, byte expectInfoClass) {
        super(config);
        this.expectInfoClass = expectInfoClass;
    }

    public FileEntry[] getResults() {
        return this.results;
    }

    @Override
    protected int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readBytesWireFormat(byte[] buffer, int bufferIndex) throws SMBProtocolDecodingException {
        FileBothDirectoryInfo cur;
        int start = bufferIndex;
        int structureSize = SMBUtil.readInt2(buffer, bufferIndex);
        if (structureSize != 9) {
            throw new SMBProtocolDecodingException("Expected structureSize = 9");
        }
        int bufferOffset = SMBUtil.readInt2(buffer, bufferIndex + 2) + this.getHeaderStart();
        int bufferLength = SMBUtil.readInt4(buffer, bufferIndex += 4);
        bufferIndex += 4;
        ArrayList<FileBothDirectoryInfo> infos = new ArrayList<FileBothDirectoryInfo>();
        while ((cur = this.createFileInfo()) != null) {
            cur.decode(buffer, bufferIndex, bufferLength);
            infos.add(cur);
            int nextEntryOffset = cur.getNextEntryOffset();
            if (nextEntryOffset > 0 && (bufferIndex += nextEntryOffset) < bufferOffset + bufferLength) continue;
        }
        this.results = infos.toArray(new FileEntry[infos.size()]);
        return bufferIndex - start;
    }

    private FileBothDirectoryInfo createFileInfo() {
        if (this.expectInfoClass == 3) {
            return new FileBothDirectoryInfo(this.getConfig(), true);
        }
        return null;
    }
}

