/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb1.smb1;

import jcifs.smb1.smb1.FileEntry;
import jcifs.smb1.smb1.SmbComTransactionResponse;
import jcifs.smb1.util.Hexdump;
import jcifs.smb1.util.LogStream;

class NetServerEnum2Response
extends SmbComTransactionResponse {
    private int converter;
    private int totalAvailableEntries;
    String lastName;

    NetServerEnum2Response() {
    }

    @Override
    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.status = NetServerEnum2Response.readInt2(buffer, bufferIndex);
        this.converter = NetServerEnum2Response.readInt2(buffer, bufferIndex += 2);
        this.numEntries = NetServerEnum2Response.readInt2(buffer, bufferIndex += 2);
        this.totalAvailableEntries = NetServerEnum2Response.readInt2(buffer, bufferIndex += 2);
        return (bufferIndex += 2) - start;
    }

    @Override
    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        ServerInfo1 e = null;
        this.results = new ServerInfo1[this.numEntries];
        for (int i = 0; i < this.numEntries; ++i) {
            e = new ServerInfo1();
            this.results[i] = e;
            e.name = this.readString(buffer, bufferIndex, 16, false);
            bufferIndex += 16;
            e.versionMajor = buffer[bufferIndex++] & 0xFF;
            e.versionMinor = buffer[bufferIndex++] & 0xFF;
            e.type = NetServerEnum2Response.readInt4(buffer, bufferIndex);
            int off = NetServerEnum2Response.readInt4(buffer, bufferIndex += 4);
            bufferIndex += 4;
            off = (off & 0xFFFF) - this.converter;
            off = start + off;
            e.commentOrMasterBrowser = this.readString(buffer, off, 48, false);
            if (LogStream.level < 4) continue;
            log.println(e);
        }
        this.lastName = this.numEntries == 0 ? null : e.name;
        return bufferIndex - start;
    }

    @Override
    public String toString() {
        return new String("NetServerEnum2Response[" + super.toString() + ",status=" + this.status + ",converter=" + this.converter + ",entriesReturned=" + this.numEntries + ",totalAvailableEntries=" + this.totalAvailableEntries + ",lastName=" + this.lastName + "]");
    }

    class ServerInfo1
    implements FileEntry {
        String name;
        int versionMajor;
        int versionMinor;
        int type;
        String commentOrMasterBrowser;

        ServerInfo1() {
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getType() {
            return (this.type & Integer.MIN_VALUE) != 0 ? 2 : 4;
        }

        @Override
        public int getAttributes() {
            return 17;
        }

        @Override
        public long createTime() {
            return 0L;
        }

        @Override
        public long lastModified() {
            return 0L;
        }

        @Override
        public long length() {
            return 0L;
        }

        public String toString() {
            return new String("ServerInfo1[name=" + this.name + ",versionMajor=" + this.versionMajor + ",versionMinor=" + this.versionMinor + ",type=0x" + Hexdump.toHexString(this.type, 8) + ",commentOrMasterBrowser=" + this.commentOrMasterBrowser + "]");
        }
    }
}

