/*
 * Decompiled with CFR 0.152.
 */
package jcifs.pac;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import jcifs.pac.PACDecodingException;
import jcifs.pac.PacDataInputStream;

public class PacSignature {
    public static final int KERB_CHECKSUM_HMAC_MD5 = -138;
    public static final int HMAC_SHA1_96_AES128 = 15;
    public static final int HMAC_SHA1_96_AES256 = 16;
    public static final int ETYPE_ARCFOUR_HMAC = 23;
    public static final int ETYPE_AES128_CTS_HMAC_SHA1_96 = 17;
    public static final int ETYPE_AES256_CTS_HMAC_SHA1_96 = 18;
    private int type;
    private byte[] checksum;

    public PacSignature(byte[] data) throws PACDecodingException {
        try {
            PacDataInputStream bufferStream = new PacDataInputStream(new DataInputStream(new ByteArrayInputStream(data)));
            this.type = bufferStream.readInt();
            switch (this.type) {
                case -138: {
                    this.checksum = new byte[16];
                    break;
                }
                case 15: 
                case 16: {
                    this.checksum = new byte[12];
                    break;
                }
                default: {
                    this.checksum = new byte[bufferStream.available()];
                }
            }
            bufferStream.readFully(this.checksum);
        }
        catch (IOException e) {
            throw new PACDecodingException("Malformed PAC signature", e);
        }
    }

    public int getType() {
        return this.type;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }
}

