/*
 * Decompiled with CFR 0.152.
 */
package jcifs.dcerpc.msrpc;

import java.io.IOException;
import jcifs.dcerpc.DcerpcException;
import jcifs.dcerpc.DcerpcHandle;
import jcifs.dcerpc.msrpc.MsrpcSamrCloseHandle;
import jcifs.dcerpc.msrpc.MsrpcSamrConnect2;
import jcifs.dcerpc.msrpc.MsrpcSamrConnect4;
import jcifs.dcerpc.rpc;
import jcifs.smb.SmbException;

public class SamrPolicyHandle
extends rpc.policy_handle
implements AutoCloseable {
    private final DcerpcHandle handle;
    private boolean opened;

    public SamrPolicyHandle(DcerpcHandle handle, String server, int access) throws IOException {
        this.handle = handle;
        if (server == null) {
            server = "\\\\";
        }
        MsrpcSamrConnect4 rpc2 = new MsrpcSamrConnect4(server, access, this);
        try {
            handle.sendrecv(rpc2);
        }
        catch (DcerpcException de) {
            if (de.getErrorCode() != 469827586) {
                throw de;
            }
            MsrpcSamrConnect2 rpc22 = new MsrpcSamrConnect2(server, access, this);
            handle.sendrecv(rpc22);
        }
        this.opened = true;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.opened) {
            this.opened = false;
            MsrpcSamrCloseHandle rpc2 = new MsrpcSamrCloseHandle(this);
            this.handle.sendrecv(rpc2);
            if (rpc2.retval != 0) {
                throw new SmbException(rpc2.retval, false);
            }
        }
    }
}

