/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb1.smb1;

import jcifs.smb1.smb1.SmbComTransaction;

class Trans2SetFileInformation
extends SmbComTransaction {
    static final int SMB_FILE_BASIC_INFO = 257;
    private int fid;
    private int attributes;
    private long createTime;
    private long lastWriteTime;

    Trans2SetFileInformation(int fid, int attributes, long createTime, long lastWriteTime) {
        this.fid = fid;
        this.attributes = attributes;
        this.createTime = createTime;
        this.lastWriteTime = lastWriteTime;
        this.command = (byte)50;
        this.subCommand = (byte)8;
        this.maxParameterCount = 6;
        this.maxDataCount = 0;
        this.maxSetupCount = 0;
    }

    @Override
    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex++] = this.subCommand;
        dst[dstIndex++] = 0;
        return 2;
    }

    @Override
    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        Trans2SetFileInformation.writeInt2(this.fid, dst, dstIndex);
        Trans2SetFileInformation.writeInt2(257L, dst, dstIndex += 2);
        Trans2SetFileInformation.writeInt2(0L, dst, dstIndex += 2);
        return (dstIndex += 2) - start;
    }

    @Override
    int writeDataWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        Trans2SetFileInformation.writeTime(this.createTime, dst, dstIndex);
        Trans2SetFileInformation.writeInt8(0L, dst, dstIndex += 8);
        Trans2SetFileInformation.writeTime(this.lastWriteTime, dst, dstIndex += 8);
        Trans2SetFileInformation.writeInt8(0L, dst, dstIndex += 8);
        Trans2SetFileInformation.writeInt2(0x80 | this.attributes, dst, dstIndex += 8);
        Trans2SetFileInformation.writeInt8(0L, dst, dstIndex += 2);
        return (dstIndex += 6) - start;
    }

    @Override
    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    public String toString() {
        return new String("Trans2SetFileInformation[" + super.toString() + ",fid=" + this.fid + "]");
    }
}

