/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.security.GeneralSecurityException;
import java.util.Arrays;
import jcifs.CIFSContext;
import jcifs.smb.NtlmPasswordAuthenticator;
import jcifs.smb.SmbException;

@Deprecated
public class NtlmPasswordAuthentication
extends NtlmPasswordAuthenticator {
    private static final long serialVersionUID = -2832037191318016836L;
    private byte[] ansiHash;
    private byte[] unicodeHash;
    private boolean hashesExternal = false;
    private CIFSContext context;

    private NtlmPasswordAuthentication() {
    }

    public NtlmPasswordAuthentication(CIFSContext tc) {
        this(tc, "", "", "");
    }

    public NtlmPasswordAuthentication(CIFSContext tc, String userInfo) {
        super(userInfo, tc.getConfig().getDefaultDomain(), tc.getConfig().getDefaultUsername() != null ? tc.getConfig().getDefaultUsername() : "GUEST", tc.getConfig().getDefaultPassword() != null ? tc.getConfig().getDefaultPassword() : "");
        this.context = tc;
    }

    public NtlmPasswordAuthentication(CIFSContext tc, String domain, String username, String password) {
        super(domain != null ? domain : tc.getConfig().getDefaultDomain(), username != null ? username : (tc.getConfig().getDefaultUsername() != null ? tc.getConfig().getDefaultUsername() : "GUEST"), password != null ? password : (tc.getConfig().getDefaultPassword() != null ? tc.getConfig().getDefaultPassword() : ""));
        this.context = tc;
    }

    public NtlmPasswordAuthentication(String domain, String username, byte[] challenge, byte[] ansiHash, byte[] unicodeHash) {
        super(domain, username, null);
        if (domain == null || username == null || ansiHash == null || unicodeHash == null) {
            throw new IllegalArgumentException("External credentials cannot be null");
        }
        this.ansiHash = ansiHash;
        this.unicodeHash = unicodeHash;
        this.hashesExternal = true;
    }

    protected CIFSContext getContext() {
        return this.context;
    }

    @Override
    public NtlmPasswordAuthentication clone() {
        NtlmPasswordAuthentication cloned = new NtlmPasswordAuthentication();
        NtlmPasswordAuthentication.cloneInternal(cloned, this);
        return cloned;
    }

    protected static void cloneInternal(NtlmPasswordAuthentication to, NtlmPasswordAuthentication from) {
        to.context = from.context;
        if (from.hashesExternal) {
            to.hashesExternal = true;
            to.ansiHash = from.ansiHash != null ? Arrays.copyOf(from.ansiHash, from.ansiHash.length) : null;
            to.unicodeHash = from.unicodeHash != null ? Arrays.copyOf(from.unicodeHash, from.unicodeHash.length) : null;
        } else {
            NtlmPasswordAuthenticator.cloneInternal(to, from);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof NtlmPasswordAuthentication)) {
                return !this.areHashesExternal();
            }
            NtlmPasswordAuthentication ntlm = (NtlmPasswordAuthentication)obj;
            if (this.areHashesExternal() && ntlm.areHashesExternal()) {
                return Arrays.equals(this.ansiHash, ntlm.ansiHash) && Arrays.equals(this.unicodeHash, ntlm.unicodeHash);
            }
            return true;
        }
        return false;
    }

    public boolean areHashesExternal() {
        return this.hashesExternal;
    }

    @Override
    public byte[] getAnsiHash(CIFSContext tc, byte[] chlng) throws GeneralSecurityException {
        if (this.hashesExternal) {
            return this.ansiHash;
        }
        return super.getAnsiHash(tc, chlng);
    }

    @Override
    public byte[] getUnicodeHash(CIFSContext tc, byte[] chlng) throws GeneralSecurityException {
        if (this.hashesExternal) {
            return this.unicodeHash;
        }
        return super.getUnicodeHash(tc, chlng);
    }

    @Override
    public byte[] getUserSessionKey(CIFSContext tc, byte[] chlng) {
        if (this.hashesExternal) {
            return null;
        }
        return super.getUserSessionKey(tc, chlng);
    }

    @Override
    public void getUserSessionKey(CIFSContext tc, byte[] chlng, byte[] dest, int offset) throws SmbException {
        if (this.hashesExternal) {
            return;
        }
        super.getUserSessionKey(tc, chlng, dest, offset);
    }
}

