/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.codejargon.fluentjdbc.api.FluentJdbcSqlException;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.query.Transaction;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;

class TransactionInternal
implements Transaction {
    private static ThreadLocal<Map<ConnectionProvider, Connection>> connections = new ThreadLocal();
    private final QueryInternal queryInternal;
    private Optional<Transaction.Isolation> isolation;

    TransactionInternal(QueryInternal queryInternal) {
        this.queryInternal = queryInternal;
        this.isolation = queryInternal.config.defaultTransactionIsolation;
    }

    @Override
    public Transaction isolation(Transaction.Isolation isolation) {
        this.isolation = Optional.of(isolation);
        return this;
    }

    @Override
    public <T> T in(Supplier<T> supplier) {
        Map<ConnectionProvider, Connection> map = this.connections();
        Optional<Connection> optional = Optional.ofNullable(map.get(this.queryInternal.connectionProvider));
        return !optional.isPresent() ? this.inNewTransaction(supplier, map) : supplier.get();
    }

    @Override
    public void inNoResult(Runnable runnable) {
        this.in(() -> {
            runnable.run();
            return null;
        });
    }

    private <T> T inNewTransaction(Supplier<T> supplier, Map<ConnectionProvider, Connection> map) {
        try {
            ArrayList arrayList = new ArrayList(1);
            this.queryInternal.connectionProvider.provide(connection -> {
                Boolean bl = null;
                try {
                    this.isolation(connection);
                    bl = connection.getAutoCommit();
                    map.put(this.queryInternal.connectionProvider, connection);
                    try {
                        arrayList.add(supplier.get());
                    }
                    catch (RuntimeException runtimeException) {
                        if (!connection.getAutoCommit()) {
                            connection.rollback();
                        }
                        throw runtimeException;
                    }
                    connection.commit();
                    this.restoreOriginalAutocommit(connection, bl);
                    this.removeTransactionedConnection(map);
                }
                catch (SQLException sQLException) {
                    try {
                        throw new FluentJdbcSqlException("Error executing transaction", sQLException);
                    }
                    catch (Throwable throwable) {
                        this.restoreOriginalAutocommit(connection, bl);
                        this.removeTransactionedConnection(map);
                        throw throwable;
                    }
                }
            });
            return (T)arrayList.get(0);
        }
        catch (SQLException sQLException) {
            throw new FluentJdbcSqlException("Error executing transaction.", sQLException);
        }
    }

    private void isolation(Connection connection) throws SQLException {
        if (this.isolation.isPresent()) {
            connection.setTransactionIsolation(this.isolation.get().jdbcIsolation());
        }
    }

    private Map<ConnectionProvider, Connection> connections() {
        Map<ConnectionProvider, Connection> map = connections.get();
        if (map == null) {
            map = new ConcurrentHashMap<ConnectionProvider, Connection>(4);
            connections.set(map);
        }
        return map;
    }

    private void removeTransactionedConnection(Map<ConnectionProvider, Connection> map) {
        map.remove(this.queryInternal.connectionProvider);
        if (map.isEmpty()) {
            connections.remove();
        }
    }

    private void restoreOriginalAutocommit(Connection connection, Boolean bl) {
        try {
            if (bl != null && bl.booleanValue()) {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static Optional<Connection> transactionedConnection(ConnectionProvider connectionProvider) throws SQLException {
        Optional<Connection> optional;
        Optional<Connection> optional2 = optional = connections.get() != null ? Optional.ofNullable(connections.get().get(connectionProvider)) : Optional.empty();
        if (optional.isPresent() && ((Connection)optional.get()).getAutoCommit()) {
            optional.get().setAutoCommit(false);
        }
        return optional;
    }
}

