/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.codejargon.fluentjdbc.internal.query.QueryConfig;
import org.codejargon.fluentjdbc.internal.query.SingleQueryBase;
import org.codejargon.fluentjdbc.internal.query.SqlAndParams;

class PreparedStatementFactory {
    public static final String[] emptyGenColumns = new String[0];
    private final QueryConfig config;

    PreparedStatementFactory(QueryConfig queryConfig) {
        this.config = queryConfig;
    }

    PreparedStatement createSingle(Connection connection, SingleQueryBase singleQueryBase, boolean bl, String[] stringArray) throws SQLException {
        SqlAndParams sqlAndParams = singleQueryBase.sqlAndParams(this.config);
        PreparedStatement preparedStatement = this.prepareStatement(connection, sqlAndParams.sql(), bl, stringArray);
        singleQueryBase.customizeQuery(preparedStatement, this.config);
        this.assignParams(preparedStatement, sqlAndParams.params());
        return preparedStatement;
    }

    PreparedStatement createBatch(Connection connection, Boolean bl, String string) throws SQLException {
        return this.prepareStatement(connection, string, bl, emptyGenColumns);
    }

    void assignParams(PreparedStatement preparedStatement, List<?> list) throws SQLException {
        this.config.paramAssigner.assignParams(preparedStatement, list);
    }

    private PreparedStatement prepareStatement(Connection connection, String string, Boolean bl, String[] stringArray) throws SQLException {
        return bl.booleanValue() ? (stringArray.length > 0 ? connection.prepareStatement(string, stringArray) : connection.prepareStatement(string, 1)) : connection.prepareStatement(string);
    }
}

