/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.api.query.BatchQuery;
import org.codejargon.fluentjdbc.api.query.UpdateResult;
import org.codejargon.fluentjdbc.internal.query.QueryInternal;
import org.codejargon.fluentjdbc.internal.query.UpdateResultInternal;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSql;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSqlFactory;
import org.codejargon.fluentjdbc.internal.query.namedparameter.SqlAndParamsForNamed;
import org.codejargon.fluentjdbc.internal.support.Ints;
import org.codejargon.fluentjdbc.internal.support.Iterables;
import org.codejargon.fluentjdbc.internal.support.Preconditions;
import org.codejargon.fluentjdbc.internal.support.Sneaky;

class BatchQueryInternal
implements BatchQuery {
    private static final String namedSet = "Named parameters are already set.";
    private static final String positionalSet = "Positional parameters are already set.";
    private final String sql;
    private final QueryInternal query;
    private Optional<Iterator<List<?>>> params = Optional.empty();
    private Optional<Iterator<Map<String, ?>>> namedParams = Optional.empty();
    private Optional<Integer> batchSize = Optional.empty();

    public BatchQueryInternal(String string, QueryInternal queryInternal) {
        this.sql = string;
        this.query = queryInternal;
    }

    @Override
    public BatchQuery params(Iterator<List<?>> iterator) {
        Preconditions.checkNotNull(iterator, "params");
        Preconditions.checkArgument(!this.params.isPresent(), positionalSet);
        Preconditions.checkArgument(!this.namedParams.isPresent(), namedSet);
        this.params = Optional.of(iterator);
        return this;
    }

    @Override
    public BatchQuery params(Iterable<List<?>> iterable) {
        return this.params(iterable.iterator());
    }

    @Override
    public BatchQuery params(Stream<List<?>> stream) {
        return this.params(stream.iterator());
    }

    @Override
    public BatchQuery namedParams(Iterator<Map<String, ?>> iterator) {
        Preconditions.checkNotNull(iterator, "namedParams");
        Preconditions.checkArgument(!this.namedParams.isPresent(), namedSet);
        Preconditions.checkArgument(!this.params.isPresent(), positionalSet);
        this.namedParams = Optional.of(iterator);
        return this;
    }

    @Override
    public BatchQuery namedParams(Iterable<Map<String, ?>> iterable) {
        return this.namedParams(iterable.iterator());
    }

    @Override
    public BatchQuery namedParams(Stream<Map<String, ?>> stream) {
        return this.namedParams(stream.iterator());
    }

    @Override
    public BatchQuery batchSize(Integer n) {
        Preconditions.checkNotNull(n, "batch size");
        Preconditions.checkArgument(n > 0, "batch size must be greater than 0");
        this.batchSize = Optional.of(n);
        return this;
    }

    @Override
    public List<UpdateResult> run() {
        Preconditions.checkArgument(this.params.isPresent() || this.namedParams.isPresent(), "Parameters must be set to run a batch query");
        return this.query.query(connection -> this.params.isPresent() ? this.positional(connection) : this.named(connection), Optional.of(this.sql));
    }

    private List<UpdateResult> positional(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = this.query.preparedStatementFactory.createBatch(connection, this.sql);){
            List<UpdateResult> list = this.runBatches(preparedStatement, Iterables.stream(this.params.get()));
            return list;
        }
    }

    private List<UpdateResult> named(Connection connection) throws SQLException {
        Iterator<Map<String, ?>> iterator = this.namedParams.get();
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        Map<String, ?> map = iterator.next();
        this.noCollectionsAllowed(map);
        NamedTransformedSql namedTransformedSql = this.query.config.namedTransformedSqlFactory.create(this.sql, map);
        try (PreparedStatement preparedStatement = this.query.preparedStatementFactory.createBatch(connection, namedTransformedSql.sql());){
            BatchExecution batchExecution = new BatchExecution(preparedStatement);
            batchExecution.add(SqlAndParamsForNamed.params(namedTransformedSql.parsedSql(), map));
            while (iterator.hasNext()) {
                map = iterator.next();
                this.noCollectionsAllowed(map);
                batchExecution.add(SqlAndParamsForNamed.params(namedTransformedSql.parsedSql(), map));
            }
            List list = batchExecution.results();
            return list;
        }
    }

    private void noCollectionsAllowed(Map<String, ?> map) {
        if (NamedTransformedSqlFactory.hasCollection(map)) {
            throw new FluentJdbcException("Batch updates should not contain collections as parameters");
        }
    }

    private List<UpdateResult> runBatches(PreparedStatement preparedStatement, Stream<List<?>> stream) throws SQLException {
        BatchExecution batchExecution = new BatchExecution(preparedStatement);
        stream.forEachOrdered(Sneaky.consumer(batchExecution::add));
        return batchExecution.results();
    }

    private class BatchExecution {
        private final PreparedStatement ps;
        private final List<UpdateResult> updateResults = new ArrayList<UpdateResult>();
        private long totalBatchesAdded = 0L;
        private boolean newAdded = false;

        public BatchExecution(PreparedStatement preparedStatement) {
            this.ps = preparedStatement;
        }

        public void add(List<?> list) throws SQLException {
            this.addParamsToBatch(list);
            if (BatchQueryInternal.this.batchSize.isPresent() && this.totalBatchesAdded % (long)((Integer)BatchQueryInternal.this.batchSize.get()).intValue() == 0L) {
                this.runBatch();
            }
        }

        private void addParamsToBatch(List<?> list) throws SQLException {
            BatchQueryInternal.this.query.assignParams(this.ps, list);
            this.ps.addBatch();
            ++this.totalBatchesAdded;
            this.newAdded = true;
        }

        private void runBatch() throws SQLException {
            this.updateResults.addAll(Ints.asList(this.ps.executeBatch()).stream().map(n -> (long)n).map(UpdateResultInternal::new).collect(Collectors.toList()));
            this.ps.clearBatch();
            this.newAdded = false;
        }

        private List<UpdateResult> results() throws SQLException {
            if (this.newAdded) {
                this.runBatch();
            }
            return Collections.unmodifiableList(this.updateResults);
        }
    }
}

