/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.codejargon.fluentjdbc.api.ParamSetter;
import org.codejargon.fluentjdbc.api.query.listen.AfterQueryListener;
import org.codejargon.fluentjdbc.internal.query.DefaultParamSetters;
import org.codejargon.fluentjdbc.internal.query.ParamAssigner;
import org.codejargon.fluentjdbc.internal.query.namedparameter.NamedTransformedSql;
import org.codejargon.fluentjdbc.internal.support.Maps;

public class QueryConfig {
    final ParamAssigner paramAssigner;
    final Map<String, NamedTransformedSql> namedParamSqlCache;
    final Optional<Integer> defaultFetchSize;
    final AfterQueryListener afterQueryListener;

    public QueryConfig(Optional<Integer> optional, Map<Class, ParamSetter> map, AfterQueryListener afterQueryListener) {
        this.paramAssigner = new ParamAssigner(Maps.merge(DefaultParamSetters.setters(), map));
        this.namedParamSqlCache = new ConcurrentHashMap<String, NamedTransformedSql>();
        this.defaultFetchSize = optional;
        this.afterQueryListener = afterQueryListener;
    }

    NamedTransformedSql namedTransformedSql(String string) {
        if (!this.namedParamSqlCache.containsKey(string)) {
            this.namedParamSqlCache.put(string, NamedTransformedSql.forSql(string));
        }
        return this.namedParamSqlCache.get(string);
    }

    Optional<Integer> fetchSize(Optional<Integer> optional) {
        return optional.isPresent() ? optional : this.defaultFetchSize;
    }
}

