/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.util.Map;
import java.util.Optional;
import org.codejargon.fluentjdbc.internal.query.ParamAssigner;
import org.codejargon.fluentjdbc.internal.query.namedparameter.TransformedSql;

public class QueryConfig {
    final ParamAssigner paramAssigner;
    final Map<String, TransformedSql> namedParamSqlCache;
    final Optional<Integer> defaultFetchSize;

    public QueryConfig(ParamAssigner paramAssigner, Map<String, TransformedSql> namedParamSqlCache, Optional<Integer> defaultFetchSize) {
        this.paramAssigner = paramAssigner;
        this.namedParamSqlCache = namedParamSqlCache;
        this.defaultFetchSize = defaultFetchSize;
    }

    TransformedSql transformedSql(String sql) {
        if (!this.namedParamSqlCache.containsKey(sql)) {
            this.namedParamSqlCache.put(sql, TransformedSql.forSql(sql));
        }
        return this.namedParamSqlCache.get(sql);
    }

    Optional<Integer> fetchSize(Optional<Integer> selectFetchSize) {
        return selectFetchSize.isPresent() ? selectFetchSize : this.defaultFetchSize;
    }
}

