/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.internal.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.internal.query.QueryConfig;
import org.codejargon.fluentjdbc.internal.query.SingleQuerySpecification;
import org.codejargon.fluentjdbc.internal.query.SqlAndParams;

class PreparedStatementFactory {
    private final QueryConfig config;

    PreparedStatementFactory(QueryConfig config) {
        this.config = config;
    }

    PreparedStatement create(Connection con, SingleQuerySpecification querySpec) throws SQLException {
        SqlAndParams sqlAndParams = querySpec.sqlAndParams(this.config);
        PreparedStatement statement = con.prepareStatement(sqlAndParams.sql());
        this.queryCustomization(statement, querySpec);
        this.assignParams(statement, sqlAndParams.params());
        return statement;
    }

    void assignParams(PreparedStatement statement, List<Object> params) throws SQLException {
        this.config.paramAssigner.assignParams(statement, params);
    }

    private void queryCustomization(PreparedStatement statement, SingleQuerySpecification querySpec) throws SQLException {
        if (querySpec.select.isPresent()) {
            this.selectCustomization(statement, querySpec);
        }
    }

    private void selectCustomization(PreparedStatement statement, SingleQuerySpecification querySpec) throws SQLException {
        this.selectFetchSize(statement, querySpec.select.get().fetchSize);
        this.maxResults(statement, querySpec.select.get().maxRows);
    }

    private void selectFetchSize(PreparedStatement statement, Optional<Integer> selectFetchSize) throws SQLException {
        Optional<Integer> activeFetchSize = this.config.fetchSize(selectFetchSize);
        if (activeFetchSize.isPresent()) {
            statement.setFetchSize(activeFetchSize.get());
        }
    }

    private void maxResults(PreparedStatement statement, Optional<Long> maxResults) throws SQLException {
        if (maxResults.isPresent()) {
            if (maxResults.get() > Integer.MAX_VALUE) {
                this.setLargeMaxRows(statement, maxResults);
            } else {
                statement.setMaxRows((int)maxResults.get().longValue());
            }
        }
    }

    private void setLargeMaxRows(PreparedStatement statement, Optional<Long> maxResults) throws SQLException {
        try {
            statement.setLargeMaxRows(maxResults.get());
        }
        catch (SQLException e) {
            throw new FluentJdbcException(String.format("The JDBC driver %s doesn't support setLargeMaxRows(). Set max results <= Integer.MAX_VALUE", statement.getConnection().getMetaData().getDriverName()));
        }
    }
}

