/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.integration.guicepersist.jpa;

import com.google.inject.Provider;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.integration.QueryConnectionReceiver;
import org.codejargon.fluentjdbc.api.integration.guicepersist.jpa.JpaConnectionExtractor;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

class JpaConnectionProvider
implements ConnectionProvider {
    private final Provider<EntityManager> entityManagerProvider;
    private final JpaConnectionExtractor jpaConnectionExtractor;

    JpaConnectionProvider(Provider<EntityManager> provider, JpaConnectionExtractor jpaConnectionExtractor) {
        this.entityManagerProvider = provider;
        this.jpaConnectionExtractor = jpaConnectionExtractor;
    }

    public void provide(QueryConnectionReceiver queryConnectionReceiver) throws SQLException {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        if (entityManager.getTransaction().isActive()) {
            queryConnectionReceiver.receive(this.extractConnection(entityManager));
        } else {
            this.provideInNewTx(queryConnectionReceiver, entityManager);
        }
    }

    private void provideInNewTx(QueryConnectionReceiver queryConnectionReceiver, EntityManager entityManager) throws SQLException {
        entityManager.getTransaction().begin();
        try {
            queryConnectionReceiver.receive(this.extractConnection(entityManager));
            entityManager.getTransaction().commit();
        }
        catch (Exception exception) {
            entityManager.getTransaction().rollback();
            throw new FluentJdbcException("Error providing connection to FluentJdbc", (Throwable)exception);
        }
    }

    private Connection extractConnection(EntityManager entityManager) {
        try {
            Connection connection = this.jpaConnectionExtractor.extract(entityManager);
            Preconditions.checkArgument((Boolean)(connection != null ? 1 : 0), (String)"Connection returned by the provided JpaConnectionExtractor is null");
            return this.jpaConnectionExtractor.extract(entityManager);
        }
        catch (Exception exception) {
            throw new FluentJdbcException("Can't extract connection from EntityManager by the provided JpaConnectionExtractor", (Throwable)exception);
        }
    }
}

