/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.integration.guicepersist.standalone;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import org.codejargon.fluentjdbc.api.FluentJdbcSqlException;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.integration.QueryConnectionReceiver;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

class StandaloneTxConnectionProvider
implements ConnectionProvider {
    private final ThreadLocal<Optional<Connection>> currentTxConnection = new ThreadLocal<Optional<Connection>>(){

        @Override
        protected Optional<Connection> initialValue() {
            return Optional.empty();
        }
    };
    private final ConnectionProvider connectionProvider;

    StandaloneTxConnectionProvider(DataSource dataSource) {
        Preconditions.checkNotNull((Object)dataSource, (String)"dataSource");
        this.connectionProvider = q -> q.receive(dataSource.getConnection());
    }

    StandaloneTxConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public void provide(QueryConnectionReceiver query) throws SQLException {
        Optional<Connection> current = this.currentTxConnection.get();
        if (current.isPresent()) {
            query.receive(current.get());
        } else {
            try (Connection connection = this.fetchNewConnection();){
                query.receive(connection);
            }
        }
    }

    Boolean hasActiveTransaction() {
        return this.currentTxConnection.get().isPresent();
    }

    void startNewTransaction() {
        try {
            Connection connection = this.fetchNewConnection();
            connection.setAutoCommit(false);
            this.currentTxConnection.set(Optional.of(connection));
        }
        catch (SQLException e) {
            throw new FluentJdbcSqlException("Error initializing transaction", e);
        }
    }

    void commitActiveTransaction() {
        try {
            this.currentTxConnection.get().get().commit();
        }
        catch (SQLException e) {
            throw new FluentJdbcSqlException("Error committing transaction", e);
        }
    }

    void rollbackActiveTransaction() {
        try {
            this.currentTxConnection.get().get().rollback();
        }
        catch (SQLException e) {
            throw new FluentJdbcSqlException("Error rolling back transaction", e);
        }
    }

    void removeActiveTransactionConnection() {
        if (this.currentTxConnection.get().isPresent()) {
            try {
                this.currentTxConnection.get().get().close();
            }
            catch (SQLException e) {
                throw new FluentJdbcSqlException("Error closing connection after transaction commit.", e);
            }
            this.currentTxConnection.set(Optional.empty());
        }
    }

    private Connection fetchNewConnection() throws SQLException {
        ConnectionReceiver receiver = new ConnectionReceiver();
        this.connectionProvider.provide((QueryConnectionReceiver)receiver);
        return receiver.connection();
    }

    private static class ConnectionReceiver
    implements QueryConnectionReceiver {
        private Optional<Connection> connection = Optional.empty();

        private ConnectionReceiver() {
        }

        public void receive(Connection connection) {
            this.connection = Optional.of(connection);
        }

        Connection connection() {
            return this.connection.get();
        }
    }
}

