/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.integration.guicepersist.jpa;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import javax.persistence.EntityManager;
import org.codejargon.fluentjdbc.api.FluentJdbc;
import org.codejargon.fluentjdbc.api.FluentJdbcBuilder;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.integration.guicepersist.jpa.JpaConnectionExtractor;
import org.codejargon.fluentjdbc.api.integration.guicepersist.jpa.JpaConnectionProvider;
import org.codejargon.fluentjdbc.api.query.Query;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

public class JpaFluentJdbcModule
extends AbstractModule {
    private final FluentJdbcBuilder fluentJdbcBuilder;
    private final JpaConnectionExtractor jpaConnectionExtractor;

    public JpaFluentJdbcModule(FluentJdbcBuilder fluentJdbcBuilder, JpaConnectionExtractor jpaConnectionExtractor) {
        Preconditions.checkNotNull((Object)fluentJdbcBuilder, (String)"fluentJdbcBuilder");
        Preconditions.checkNotNull((Object)jpaConnectionExtractor, (String)"jpaConnectionExtractor");
        this.fluentJdbcBuilder = fluentJdbcBuilder;
        this.jpaConnectionExtractor = jpaConnectionExtractor;
    }

    protected void configure() {
        this.requireBinding(Key.get(EntityManager.class));
    }

    @Provides
    @Singleton
    FluentJdbc fluentJdbc(Provider<EntityManager> entityManagerProvider) {
        return this.fluentJdbcBuilder.connectionProvider((ConnectionProvider)new JpaConnectionProvider(entityManagerProvider, this.jpaConnectionExtractor)).build();
    }

    @Provides
    @Singleton
    Query query(FluentJdbc fluentJdbc) {
        return fluentJdbc.query();
    }
}

