/*
 * Decompiled with CFR 0.152.
 */
package org.codejargon.fluentjdbc.api.integration.guicepersist.jpa;

import com.google.inject.Provider;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import org.codejargon.fluentjdbc.api.FluentJdbcException;
import org.codejargon.fluentjdbc.api.integration.ConnectionProvider;
import org.codejargon.fluentjdbc.api.integration.QueryConnectionReceiver;
import org.codejargon.fluentjdbc.api.integration.guicepersist.jpa.JpaConnectionExtractor;
import org.codejargon.fluentjdbc.internal.support.Preconditions;

class JpaConnectionProvider
implements ConnectionProvider {
    private final Provider<EntityManager> entityManagerProvider;
    private final JpaConnectionExtractor jpaConnectionExtractor;

    JpaConnectionProvider(Provider<EntityManager> entityManagerProvider, JpaConnectionExtractor jpaConnectionExtractor) {
        this.entityManagerProvider = entityManagerProvider;
        this.jpaConnectionExtractor = jpaConnectionExtractor;
    }

    public void provide(QueryConnectionReceiver query) throws SQLException {
        EntityManager entityManager = (EntityManager)this.entityManagerProvider.get();
        if (entityManager.getTransaction().isActive()) {
            query.receive(this.extractConnection(entityManager));
        } else {
            this.provideInNewTx(query, entityManager);
        }
    }

    private void provideInNewTx(QueryConnectionReceiver query, EntityManager entityManager) throws SQLException {
        entityManager.getTransaction().begin();
        try {
            query.receive(this.extractConnection(entityManager));
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            entityManager.getTransaction().rollback();
            throw new FluentJdbcException("Error providing connection to FluentJdbc", (Throwable)e);
        }
    }

    private Connection extractConnection(EntityManager entityManager) {
        try {
            Connection connection = this.jpaConnectionExtractor.extract(entityManager);
            Preconditions.checkArgument((Boolean)(connection != null ? 1 : 0), (String)"Connection returned by the provided JpaConnectionExtractor is null");
            return this.jpaConnectionExtractor.extract(entityManager);
        }
        catch (Exception e) {
            throw new FluentJdbcException("Can't extract connection from EntityManager by the provided JpaConnectionExtractor", (Throwable)e);
        }
    }
}

