/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.jaxws;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingType;
import org.codehaus.xfire.jaxws.JAXWSHelper;
import org.codehaus.xfire.jaxws.binding.AbstractBinding;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.invoker.BeanInvoker;
import org.codehaus.xfire.service.invoker.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Endpoint
extends javax.xml.ws.Endpoint {
    private JAXWSHelper jaxWsHelper = JAXWSHelper.getInstance();
    private AbstractBinding binding;
    private Object implementor;
    private boolean published;
    private List<Source> metadata;
    private Executor executor;
    private Service service;
    private Map<String, Object> properties = new HashMap<String, Object>();

    public Endpoint(String bindingId, Object implementor) {
        BindingType type;
        if (bindingId == null && (type = implementor.getClass().getAnnotation(BindingType.class)) != null) {
            bindingId = type.value();
        }
        if (bindingId == null || bindingId.length() == 0) {
            bindingId = "http://schemas.xmlsoap.org/wsdl/soap/http";
        }
        this.binding = this.jaxWsHelper.getBinding(bindingId);
        if (this.binding == null) {
            throw new IllegalStateException("Could not find binding: " + bindingId);
        }
        this.implementor = implementor;
        this.service = this.jaxWsHelper.getServiceFactory().create(implementor.getClass());
        this.service.setInvoker((Invoker)new BeanInvoker(implementor));
    }

    public Binding getBinding() {
        return this.binding;
    }

    public Object getImplementor() {
        return this.implementor;
    }

    public void publish(String address) {
        if (this.published) {
            throw new IllegalStateException("Endpoint has already been published.");
        }
        this.jaxWsHelper.getXFire().getServiceRegistry().register(this.service);
        this.published = true;
    }

    public void publish(Object context) {
        if (this.published) {
            throw new IllegalStateException("Endpoint has already been published.");
        }
        this.published = true;
    }

    public void stop() {
        if (this.published) {
            this.jaxWsHelper.getXFire().getServiceRegistry().unregister(this.service);
            this.published = false;
        }
    }

    public boolean isPublished() {
        return this.published;
    }

    public List<Source> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<Source> metadata) {
        this.metadata = metadata;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

