/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.wsdl11.parser;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroupBase;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.service.FaultInfo;
import org.codehaus.xfire.service.MessageInfo;
import org.codehaus.xfire.service.MessagePartContainer;
import org.codehaus.xfire.service.MessagePartInfo;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceInfo;
import org.codehaus.xfire.service.binding.BindingProvider;
import org.codehaus.xfire.transport.TransportManager;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.wsdl.SchemaType;
import org.codehaus.xfire.wsdl11.ResolverWSDLLocator;
import org.codehaus.xfire.wsdl11.parser.SchemaInfo;
import org.codehaus.xfire.wsdl11.parser.SoapBindingAnnotator;
import org.codehaus.xfire.wsdl11.parser.WSDLServiceConfigurator;
import org.codehaus.xfire.wsdl11.parser.XmlSchemaURIResolver;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDLServiceBuilder {
    private static final Log log = LogFactory.getLog((Class)WSDLServiceBuilder.class);
    private PortType portType;
    private OperationInfo opInfo;
    private XmlSchemaCollection schemas = new XmlSchemaCollection();
    private boolean isWrapped = false;
    private BindingProvider bindingProvider;
    protected final Definition definition;
    private List bindingAnnotators = new ArrayList();
    private Map portType2serviceInfo = new HashMap();
    private Map wop2op = new HashMap();
    private Map winput2msg = new HashMap();
    private Map woutput2msg = new HashMap();
    private Map wfault2msg = new HashMap();
    private List schemaInfos = new ArrayList();
    private List definitions = new ArrayList();
    private List definitionPaths = new ArrayList();
    private List portTypes = new ArrayList();
    private Map types = new HashMap();
    private List wsdlServices = new ArrayList();
    private Map xFireServices = new HashMap();
    private List allServices = new ArrayList();
    private TransportManager transportManager = XFireFactory.newInstance().getXFire().getTransportManager();
    private Service service;
    private String systemId;

    public WSDLServiceBuilder(Definition definition) {
        this.definition = definition;
        this.definitions.add(definition);
        this.systemId = definition.getDocumentBaseURI();
        this.bindingAnnotators.add(new SoapBindingAnnotator());
        this.schemas.setSchemaResolver((URIResolver)new XmlSchemaURIResolver());
    }

    public WSDLServiceBuilder(InputStream is) throws WSDLException {
        this("", is);
    }

    public WSDLServiceBuilder(String baseURI, InputStream is) throws WSDLException {
        this(WSDLFactory.newInstance().newWSDLReader().readWSDL((WSDLLocator)new ResolverWSDLLocator(baseURI, new InputSource(is))));
        this.definition.setDocumentBaseURI(baseURI);
        this.systemId = baseURI;
    }

    public WSDLServiceBuilder(String baseURI, InputSource source) throws WSDLException {
        this(WSDLFactory.newInstance().newWSDLReader().readWSDL(baseURI, source));
        this.definition.setDocumentBaseURI(baseURI);
        this.systemId = source.getSystemId();
    }

    public BindingProvider getBindingProvider() {
        if (this.bindingProvider == null) {
            try {
                this.bindingProvider = (BindingProvider)ClassLoaderUtils.loadClass("org.codehaus.xfire.aegis.AegisBindingProvider", this.getClass()).newInstance();
            }
            catch (Exception e) {
                throw new XFireRuntimeException("Couldn't find a binding provider!", e);
            }
        }
        return this.bindingProvider;
    }

    public void setBindingProvider(BindingProvider bindingProvider) {
        this.bindingProvider = bindingProvider;
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public List getDefinitions() {
        return this.definitions;
    }

    public TransportManager getTransportManager() {
        return this.transportManager;
    }

    public void setTransportManager(TransportManager transportManager) {
        this.transportManager = transportManager;
    }

    public void build() throws Exception {
        this.processImports(this.definition);
        this.types.put(this.systemId, this.definition.getTypes());
        Iterator itr = this.types.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            this.visit((String)entry.getKey(), (Types)entry.getValue());
        }
        this.portTypes.addAll(this.definition.getPortTypes().values());
        itr = this.portTypes.iterator();
        while (itr.hasNext()) {
            this.portType = (PortType)itr.next();
            this.visit(this.portType);
        }
        this.wsdlServices.addAll(this.definition.getServices().values());
        Iterator iterator = this.wsdlServices.iterator();
        while (iterator.hasNext()) {
            javax.wsdl.Service wservice = (javax.wsdl.Service)iterator.next();
            Map portType2Ports = this.getPortTypeToPortMap(wservice);
            Iterator ptitr = portType2Ports.entrySet().iterator();
            while (ptitr.hasNext()) {
                Map.Entry entry = ptitr.next();
                PortType portType = (PortType)entry.getKey();
                Collection ports = (Collection)entry.getValue();
                if (ports.size() == 0) continue;
                ServiceInfo serviceInfo = this.getServiceInfo(portType);
                WSDLServiceConfigurator config = new WSDLServiceConfigurator(serviceInfo, this.definition, wservice, portType, ports, this.bindingProvider, this.transportManager);
                config.configure();
                this.addService(config.getService());
            }
        }
    }

    protected void addService(Service s) {
        ArrayList<Service> services = (ArrayList<Service>)this.xFireServices.get(s.getName());
        if (services == null) {
            services = new ArrayList<Service>();
            this.xFireServices.put(s.getName(), services);
        }
        services.add(s);
        this.allServices.add(s);
    }

    protected void processImports(Definition parent) {
        Collection imports = parent.getImports().values();
        Iterator iterator = imports.iterator();
        while (iterator.hasNext()) {
            List wsdlImports = (List)iterator.next();
            Iterator importItr = wsdlImports.iterator();
            while (importItr.hasNext()) {
                Import i = (Import)importItr.next();
                Definition iDef = i.getDefinition();
                if (this.definitionPaths.contains(i.getLocationURI())) continue;
                log.info((Object)("Adding wsdl definition " + i.getLocationURI() + " with baseURI of " + parent.getDocumentBaseURI()));
                this.definitionPaths.add(i.getLocationURI());
                try {
                    String baseURI = parent.getDocumentBaseURI();
                    String resolvedLocation = baseURI == null ? new URI(i.getLocationURI()).toString() : new URI(parent.getDocumentBaseURI()).resolve(i.getLocationURI()).toString();
                    this.types.put(resolvedLocation, iDef.getTypes());
                }
                catch (URISyntaxException e) {
                    throw new XFireRuntimeException("Couldn't resolve location " + i.getLocationURI(), e);
                }
                this.definitions.add(iDef);
                this.portTypes.addAll(iDef.getPortTypes().values());
                this.wsdlServices.addAll(iDef.getServices().values());
                this.processImports(iDef);
            }
        }
    }

    private Map getPortTypeToPortMap(javax.wsdl.Service wservice) {
        HashMap pt2port = new HashMap();
        Iterator itr = this.portTypes.iterator();
        while (itr.hasNext()) {
            PortType pt = (PortType)itr.next();
            ArrayList<Port> ports = new ArrayList<Port>();
            pt2port.put(pt, ports);
            Iterator pitr = wservice.getPorts().values().iterator();
            while (pitr.hasNext()) {
                Port port = (Port)pitr.next();
                if (!port.getBinding().getPortType().equals(pt)) continue;
                ports.add(port);
            }
        }
        return pt2port;
    }

    public Map getServices() {
        return this.xFireServices;
    }

    public List getAllServices() {
        return this.allServices;
    }

    protected void visit(String location, Types types) {
        if (types == null) {
            return;
        }
        int schemaCount = 1;
        Iterator itr = types.getExtensibilityElements().iterator();
        while (itr.hasNext()) {
            ExtensibilityElement ee = (ExtensibilityElement)itr.next();
            Element el = null;
            if (ee instanceof UnknownExtensibilityElement) {
                UnknownExtensibilityElement uee = (UnknownExtensibilityElement)ee;
                el = uee.getElement();
            } else {
                try {
                    Method mth = ee.getClass().getMethod("getElement", new Class[0]);
                    Object val = mth.invoke((Object)ee, new Object[0]);
                    el = (Element)val;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String schemaSystemId = location + "#types?schema" + schemaCount++;
            this.schemas.setBaseUri(this.definition.getDocumentBaseURI());
            XmlSchema schema = this.schemas.read(el, schemaSystemId);
            SchemaInfo schemaInfo = new SchemaInfo();
            schemaInfo.setDefinition(this.definition);
            schemaInfo.setSchema(schema);
            schemaInfo.setSchemaElement(el);
            if (this.systemId != null && !this.systemId.equals(location)) {
                schemaInfo.setImported(true);
            }
            this.schemaInfos.add(schemaInfo);
            ++schemaCount;
        }
    }

    protected void visit(PortType portType) {
        ServiceInfo serviceInfo = new ServiceInfo(null, Object.class);
        this.portType2serviceInfo.put(portType, serviceInfo);
        serviceInfo.setPortType(portType.getQName());
        Element documentation = portType.getDocumentationElement();
        if (documentation != null) {
            String docText = documentation.getNodeValue();
            serviceInfo.setDocumentation(docText);
        }
        this.isWrapped = true;
        Iterator itr = portType.getOperations().iterator();
        while (this.isWrapped && itr.hasNext()) {
            Operation o = (Operation)itr.next();
            this.isWrapped = WSDLServiceBuilder.isWrapped(o, this.schemas);
        }
        serviceInfo.setWrapped(this.isWrapped);
        List operations = portType.getOperations();
        for (int i = 0; i < operations.size(); ++i) {
            Operation operation = (Operation)operations.get(i);
            this.visit(operation);
            Input input = operation.getInput();
            this.visit(input);
            Output output = operation.getOutput();
            if (output != null) {
                this.visit(output);
            }
            Collection faults = operation.getFaults().values();
            Iterator iterator2 = faults.iterator();
            while (iterator2.hasNext()) {
                Fault fault = (Fault)iterator2.next();
                this.visit(fault);
            }
        }
    }

    protected ServiceInfo getServiceInfo(PortType portType) {
        return (ServiceInfo)this.portType2serviceInfo.get(portType);
    }

    protected void visit(Fault fault) {
        FaultInfo faultInfo = this.opInfo.addFault(fault.getName());
        faultInfo.setMessageName(fault.getMessage().getQName());
        if (fault.getDocumentationElement() != null) {
            faultInfo.setDocumentation(fault.getDocumentationElement().getNodeValue());
        }
        this.wfault2msg.put(fault, faultInfo);
        this.createMessageParts(faultInfo, fault.getMessage());
    }

    protected void visit(Input input) {
        if (this.isWrapped) {
            Part part = (Part)input.getMessage().getParts().values().iterator().next();
            MessageInfo info = this.opInfo.createMessage(new QName(part.getElementName().getNamespaceURI(), input.getMessage().getQName().getLocalPart()));
            this.winput2msg.put(input, info);
            this.opInfo.setInputMessage(info);
            this.createMessageParts(info, this.getWrappedSchema(input.getMessage()));
        } else {
            MessageInfo info = this.opInfo.createMessage(input.getMessage().getQName());
            this.winput2msg.put(input, info);
            this.opInfo.setInputMessage(info);
            this.createMessageParts((MessagePartContainer)info, input.getMessage());
        }
    }

    protected void visit(Operation operation) {
        this.opInfo = this.getServiceInfo(this.portType).addOperation(operation.getName(), null);
        Element docElem = operation.getDocumentationElement();
        if (docElem != null) {
            String docText = docElem.getNodeValue();
            this.opInfo.setDocumenation(docText);
        }
        this.wop2op.put(operation, this.opInfo);
    }

    private void createMessageParts(MessageInfo info, XmlSchemaComplexType type) {
        if (type == null) {
            return;
        }
        if (type.getParticle() instanceof XmlSchemaSequence) {
            XmlSchemaSequence seq = (XmlSchemaSequence)type.getParticle();
            XmlSchemaObjectCollection col = seq.getItems();
            Iterator itr = col.getIterator();
            while (itr.hasNext()) {
                XmlSchemaObject schemaObj = (XmlSchemaObject)itr.next();
                if (!(schemaObj instanceof XmlSchemaElement)) continue;
                this.createMessagePart(info, (XmlSchemaElement)schemaObj);
            }
        }
    }

    private void createMessagePart(MessageInfo info, XmlSchemaElement element) {
        QName schemaType;
        QName name;
        boolean globalElement;
        int index = info.size();
        boolean bl = globalElement = element.getRefName() != null;
        if (globalElement) {
            schemaType = name = element.getRefName();
        } else {
            name = element.getQName();
            schemaType = element.getSchemaTypeName();
        }
        MessagePartInfo part = info.addMessagePart(name, XmlSchemaElement.class);
        part.setIndex(index);
        part.setSchemaElement(globalElement);
        SchemaType st = this.getBindingProvider().getSchemaType(schemaType, this.service);
        part.setSchemaType(st);
    }

    public static boolean isWrapped(Operation op, XmlSchemaCollection schemas) {
        XmlSchemaComplexType ct;
        boolean hasOutput;
        Input input = op.getInput();
        Output output = op.getOutput();
        boolean bl = hasOutput = output != null && output.getMessage().getParts() != null;
        if (input.getMessage().getParts().size() != 1 || hasOutput && output.getMessage().getParts().size() != 1) {
            return false;
        }
        Part inPart = (Part)input.getMessage().getParts().values().iterator().next();
        Part outPart = null;
        if (hasOutput) {
            outPart = (Part)output.getMessage().getParts().values().iterator().next();
        }
        QName inElementName = inPart.getElementName();
        QName outElementName = null;
        if (hasOutput) {
            outElementName = outPart.getElementName();
        }
        if (inElementName == null || hasOutput && outElementName == null) {
            return false;
        }
        if (!inElementName.getLocalPart().equals(op.getName()) || hasOutput && !outElementName.getLocalPart().equals(op.getName() + "Response")) {
            return false;
        }
        XmlSchemaElement reqSchemaEl = schemas.getElementByQName(inElementName);
        XmlSchemaElement resSchemaEl = null;
        if (hasOutput) {
            resSchemaEl = schemas.getElementByQName(outElementName);
        }
        if (reqSchemaEl == null) {
            throw new XFireRuntimeException("Couldn't find schema part: " + inElementName);
        }
        if (hasOutput && resSchemaEl == null) {
            throw new XFireRuntimeException("Couldn't find schema part: " + outElementName);
        }
        if (reqSchemaEl.getSchemaType() instanceof XmlSchemaComplexType) {
            ct = (XmlSchemaComplexType)reqSchemaEl.getSchemaType();
            if (WSDLServiceBuilder.hasAttributes(ct) || ct.getContentModel() != null) {
                return false;
            }
            if (ct.getParticle() != null && !(ct.getParticle() instanceof XmlSchemaSequence) && !(ct.getParticle() instanceof XmlSchemaAll)) {
                return false;
            }
            if (WSDLServiceBuilder.containsAnonymousTypes(ct)) {
                return false;
            }
        } else if (reqSchemaEl.getSchemaType() != null) {
            return false;
        }
        if (hasOutput && resSchemaEl.getSchemaType() instanceof XmlSchemaComplexType) {
            ct = (XmlSchemaComplexType)resSchemaEl.getSchemaType();
            if (WSDLServiceBuilder.hasAttributes(ct)) {
                return false;
            }
            if (ct.getContentModel() != null) {
                return false;
            }
            if (ct.getParticle() != null && !(ct.getParticle() instanceof XmlSchemaSequence) && !(ct.getParticle() instanceof XmlSchemaAll)) {
                return false;
            }
            if (WSDLServiceBuilder.containsAnonymousTypes(ct)) {
                return false;
            }
        } else if (hasOutput && resSchemaEl.getSchemaType() != null) {
            return false;
        }
        return true;
    }

    private static boolean containsAnonymousTypes(XmlSchemaComplexType ct) {
        XmlSchemaGroupBase particle = (XmlSchemaGroupBase)ct.getParticle();
        if (particle == null) {
            return false;
        }
        XmlSchemaObjectCollection items = particle.getItems();
        for (int i = 0; i < items.getCount(); ++i) {
            XmlSchemaElement el;
            XmlSchemaObject item = items.getItem(i);
            if (!(item instanceof XmlSchemaElement ? (el = (XmlSchemaElement)item).getSchemaTypeName() == null : item instanceof XmlSchemaElement && (el = (XmlSchemaComplexType)item).getParticle() != null)) continue;
            return true;
        }
        return false;
    }

    private XmlSchemaComplexType getWrappedSchema(Message message) {
        Part part = (Part)message.getParts().values().iterator().next();
        XmlSchemaElement schemaEl = this.schemas.getElementByQName(part.getElementName());
        if (schemaEl.getSchemaType() instanceof XmlSchemaComplexType) {
            return (XmlSchemaComplexType)schemaEl.getSchemaType();
        }
        return null;
    }

    protected static boolean hasAttributes(XmlSchemaComplexType complexType) {
        return complexType.getAnyAttribute() != null || complexType.getAttributes().getCount() > 0;
    }

    private void createMessageParts(MessagePartContainer info, Message msg) {
        List parts = msg.getOrderedParts(null);
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            QName elementName;
            MessagePartInfo part;
            Part entry = (Part)itr.next();
            QName typeName = entry.getTypeName();
            if (typeName != null) {
                QName partName = new QName(this.getTargetNamespace(), entry.getName());
                part = info.addMessagePart(partName, null);
                part.setSchemaElement(false);
                part.setSchemaType(this.getBindingProvider().getSchemaType(typeName, this.service));
                part.setIndex(info.size() - 1);
            }
            if ((elementName = entry.getElementName()) == null) continue;
            part = info.addMessagePart(elementName, null);
            part.setSchemaType(this.getBindingProvider().getSchemaType(typeName, this.service));
            part.setIndex(info.size() - 1);
            if (entry.getDocumentationElement() == null) continue;
            part.setDocumentation(entry.getDocumentationElement().getNodeValue());
        }
    }

    protected String getTargetNamespace() {
        return this.getDefinition().getTargetNamespace();
    }

    protected void visit(Output output) {
        MessageInfo info = this.opInfo.createMessage(new QName(this.opInfo.getInputMessage().getName().getNamespaceURI(), output.getMessage().getQName().getLocalPart()));
        this.opInfo.setOutputMessage(info);
        this.woutput2msg.put(output, info);
        if (this.isWrapped) {
            this.createMessageParts(info, this.getWrappedSchema(output.getMessage()));
        } else {
            this.createMessageParts((MessagePartContainer)info, output.getMessage());
        }
    }

    public List getSchemas() {
        return this.schemaInfos;
    }

    public XmlSchemaCollection getSchemaCollection() {
        return this.schemas;
    }
}

