package org.xdoclet.plugin.hibernate.qtags;

public class HibernateKeyTagImpl extends org.xdoclet.XDocletTag implements org.xdoclet.plugin.hibernate.qtags.HibernateKeyTag {
    public static final String NAME = "hibernate.key";
    private static final java.util.List ALLOWED_PARAMETERS = java.util.Arrays.asList( new String[] {
		"on-delete",
		"foreign-key",
		"property-ref",
		"not-null",
		"unique",
		"update",
		"column",
    	""
    });
    
    private static final java.util.List ALLOWED_VALUES = java.util.Arrays.asList( new String[] {
        ""
    });
    public HibernateKeyTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber, org.xdoclet.QDoxPropertyExpander expander) {
        super(name, value, entity, lineNumber, expander);
    }
    public HibernateKeyTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public java.lang.String getOnDelete() {
		boolean required = false;
        String result = getNamedParameter("on-delete");
        if(required && result == null) {
            bomb("on-delete=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            if( !(false || result.equals("cascade")|| result.equals("noaction")) ) {
	                // todo we should say what file and line number too
	                bomb("on-delete=\"" + result + "\" is an invalid parameter value.");
	            }
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getForeignKey() {
		boolean required = false;
        String result = getNamedParameter("foreign-key");
        if(required && result == null) {
            bomb("foreign-key=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getPropertyRef() {
		boolean required = false;
        String result = getNamedParameter("property-ref");
        if(required && result == null) {
            bomb("property-ref=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Boolean getNotNull() {
		boolean required = false;
        String result = getNamedParameter("not-null");
        if(required && result == null) {
            bomb("not-null=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.Boolean getUnique() {
		boolean required = false;
        String result = getNamedParameter("unique");
        if(required && result == null) {
            bomb("unique=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.Boolean getUpdate() {
		boolean required = false;
        String result = getNamedParameter("update");
        if(required && result == null) {
            bomb("update=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getColumn() {
		boolean required = false;
        String result = getNamedParameter("column");
        if(required && result == null) {
            bomb("column=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }

    protected void validateLocation() {
		if(isOnClass) {
        	bomb("is not allowed on classes");
		}
		if(isOnConstructor) {
        	bomb("is not allowed on constructors");
		}
        
        // check uniqueness

        // warn deprecation
        
        // check for allowed values for whole tag
        if( ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(getValue())) {
            bomb( "\"" + getValue() +"\" is not a valid value. Allowed values are ");
        }        
        // Verify that all parameters are known.
        final java.util.Collection parameterNames = getNamedParameterMap().keySet();
        for (java.util.Iterator iterator = parameterNames.iterator(); iterator.hasNext();) {
            String parameterName = (String) iterator.next();
            if (!ALLOWED_PARAMETERS.contains(parameterName)) {
                bomb(parameterName + " is an invalid parameter name.");
            }
        }
        
        // Get all the parameters to validate their contents
        getOnDelete();
        getForeignKey();
        getPropertyRef();
        getNotNull();
        getUnique();
        getUpdate();
        getColumn();
    }

    public void validateModel() {
        // check uniqueness
    }
}