package org.xdoclet.plugin.hibernate.qtags;

public class HibernateKeyManyToOneTagImpl extends org.xdoclet.XDocletTag implements org.xdoclet.plugin.hibernate.qtags.HibernateKeyManyToOneTag {
    public static final String NAME = "hibernate.key-many-to-one";
    private static final java.util.List ALLOWED_PARAMETERS = java.util.Arrays.asList( new String[] {
		"name",
		"lazy",
		"foreign-key",
		"class",
		"position",
		"entity-name",
		"access",
		"column",
    	""
    });
    
    private static final java.util.List ALLOWED_VALUES = java.util.Arrays.asList( new String[] {
        ""
    });
    public HibernateKeyManyToOneTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber, org.xdoclet.QDoxPropertyExpander expander) {
        super(name, value, entity, lineNumber, expander);
    }
    public HibernateKeyManyToOneTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public java.lang.String getName_() {
		boolean required = false;
        String result = getNamedParameter("name");
        if(required && result == null) {
            bomb("name=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getLazy() {
		boolean required = false;
        String result = getNamedParameter("lazy");
        if(required && result == null) {
            bomb("lazy=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            if( !(false || result.equals("true")|| result.equals("false")|| result.equals("proxy")|| result.equals("no-proxy")|| result.equals("extra")) ) {
	                // todo we should say what file and line number too
	                bomb("lazy=\"" + result + "\" is an invalid parameter value.");
	            }
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getForeignKey() {
		boolean required = false;
        String result = getNamedParameter("foreign-key");
        if(required && result == null) {
            bomb("foreign-key=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getClass_() {
		boolean required = false;
        String result = getNamedParameter("class");
        if(required && result == null) {
            bomb("class=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Integer getPosition() {
		boolean required = false;
        String result = getNamedParameter("position");
        if(required && result == null) {
            bomb("position=\"???\" must be specified.");
        }

		java.lang.Integer retVal = null;

        if(result == null) {
            result = "1";
        }

		if (result != null) {
	            try {
	                retVal = Integer.decode(result);
	            } catch(NumberFormatException nfe) {
	                bomb("position=\"" + result + "\" is not valid integer");
	                throw nfe;
	            }
		}
		
		return retVal;
    }
    public java.lang.String getEntityName() {
		boolean required = false;
        String result = getNamedParameter("entity-name");
        if(required && result == null) {
            bomb("entity-name=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getAccess() {
		boolean required = false;
        String result = getNamedParameter("access");
        if(required && result == null) {
            bomb("access=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getColumn() {
		boolean required = false;
        String result = getNamedParameter("column");
        if(required && result == null) {
            bomb("column=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }

    protected void validateLocation() {
		if(isOnClass) {
        	bomb("is not allowed on classes");
		}
		if(isOnConstructor) {
        	bomb("is not allowed on constructors");
		}
        
        // check uniqueness
        // deprecated here. check validateModel
		if(((com.thoughtworks.qdox.model.AbstractJavaEntity)getContext()).getTagsByName(NAME).length > 1) {
			bomb("is allowed only once");
		}

        // warn deprecation
        
        // check for allowed values for whole tag
        if( ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(getValue())) {
            bomb( "\"" + getValue() +"\" is not a valid value. Allowed values are ");
        }        
        // Verify that all parameters are known.
        final java.util.Collection parameterNames = getNamedParameterMap().keySet();
        for (java.util.Iterator iterator = parameterNames.iterator(); iterator.hasNext();) {
            String parameterName = (String) iterator.next();
            if (!ALLOWED_PARAMETERS.contains(parameterName)) {
                bomb(parameterName + " is an invalid parameter name.");
            }
        }
        
        // Get all the parameters to validate their contents
        getName_();
        getLazy();
        getForeignKey();
        getClass_();
        getPosition();
        getEntityName();
        getAccess();
        getColumn();
    }

    public void validateModel() {
        // check uniqueness
        if(((com.thoughtworks.qdox.model.AbstractJavaEntity)getContext()).getTagsByName(NAME).length > 1) {
            bomb("is allowed only once");
        }
    }
}