package org.xdoclet.plugin.hibernate.qtags;

public class HibernateAnyColumnTagImpl extends org.xdoclet.XDocletTag implements org.xdoclet.plugin.hibernate.qtags.HibernateAnyColumnTag {
    public static final String NAME = "hibernate.any-column";
    private static final java.util.List ALLOWED_PARAMETERS = java.util.Arrays.asList( new String[] {
		"name",
		"unique-key",
		"comment",
		"check",
		"index",
		"unique",
		"not-null",
		"precision",
		"length",
		"sql-type",
		"scale",
    	""
    });
    
    private static final java.util.List ALLOWED_VALUES = java.util.Arrays.asList( new String[] {
        ""
    });
    public HibernateAnyColumnTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber, org.xdoclet.QDoxPropertyExpander expander) {
        super(name, value, entity, lineNumber, expander);
    }
    public HibernateAnyColumnTagImpl(String name, String value, com.thoughtworks.qdox.model.AbstractBaseJavaEntity entity, int lineNumber) {
        super(name, value, entity, lineNumber);
    }

    public java.lang.String getName_() {
		boolean required = true;
        String result = getNamedParameter("name");
        if(required && result == null) {
            bomb("name=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getUniqueKey() {
		boolean required = false;
        String result = getNamedParameter("unique-key");
        if(required && result == null) {
            bomb("unique-key=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getComment() {
		boolean required = false;
        String result = getNamedParameter("comment");
        if(required && result == null) {
            bomb("comment=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getCheck() {
		boolean required = false;
        String result = getNamedParameter("check");
        if(required && result == null) {
            bomb("check=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getIndex() {
		boolean required = false;
        String result = getNamedParameter("index");
        if(required && result == null) {
            bomb("index=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Boolean getUnique() {
		boolean required = false;
        String result = getNamedParameter("unique");
        if(required && result == null) {
            bomb("unique=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.Boolean getNotNull() {
		boolean required = false;
        String result = getNamedParameter("not-null");
        if(required && result == null) {
            bomb("not-null=\"???\" must be specified.");
        }

		java.lang.Boolean retVal = null;


		if (result != null) {
		        retVal = Boolean.valueOf(result);
		}
		
		return retVal;
    }
    public java.lang.String getPrecision() {
		boolean required = false;
        String result = getNamedParameter("precision");
        if(required && result == null) {
            bomb("precision=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.Integer getLength() {
		boolean required = false;
        String result = getNamedParameter("length");
        if(required && result == null) {
            bomb("length=\"???\" must be specified.");
        }

		java.lang.Integer retVal = null;


		if (result != null) {
	            try {
	                retVal = Integer.decode(result);
	            } catch(NumberFormatException nfe) {
	                bomb("length=\"" + result + "\" is not valid integer");
	                throw nfe;
	            }
		}
		
		return retVal;
    }
    public java.lang.String getSqlType() {
		boolean required = false;
        String result = getNamedParameter("sql-type");
        if(required && result == null) {
            bomb("sql-type=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }
    public java.lang.String getScale() {
		boolean required = false;
        String result = getNamedParameter("scale");
        if(required && result == null) {
            bomb("scale=\"???\" must be specified.");
        }

		java.lang.String retVal = null;


		if (result != null) {
	            retVal = result;
		}
		
		return retVal;
    }

    protected void validateLocation() {
		if(isOnClass) {
        	bomb("is not allowed on classes");
		}
		if(isOnConstructor) {
        	bomb("is not allowed on constructors");
		}
        
        // check uniqueness

        // warn deprecation
        
        // check for allowed values for whole tag
        if( ALLOWED_VALUES.size() > 1 && !ALLOWED_VALUES.contains(getValue())) {
            bomb( "\"" + getValue() +"\" is not a valid value. Allowed values are ");
        }        
        // Verify that all parameters are known.
        final java.util.Collection parameterNames = getNamedParameterMap().keySet();
        for (java.util.Iterator iterator = parameterNames.iterator(); iterator.hasNext();) {
            String parameterName = (String) iterator.next();
            if (!ALLOWED_PARAMETERS.contains(parameterName)) {
                bomb(parameterName + " is an invalid parameter name.");
            }
        }
        
        // Get all the parameters to validate their contents
        getName_();
        getUniqueKey();
        getComment();
        getCheck();
        getIndex();
        getUnique();
        getNotNull();
        getPrecision();
        getLength();
        getSqlType();
        getScale();
    }

    public void validateModel() {
        // check uniqueness
    }
}