/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.osgitools.targetplatform;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Mirror;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.DefaultTargetPlatform;
import org.codehaus.tycho.TargetPlatform;
import org.codehaus.tycho.TargetPlatformResolver;
import org.codehaus.tycho.model.Feature;
import org.codehaus.tycho.model.PluginRef;
import org.codehaus.tycho.osgitools.targetplatform.AbstractTargetPlatformResolver;
import org.codehaus.tycho.osgitools.targetplatform.EclipseInstallationLayout;
import org.codehaus.tycho.osgitools.targetplatform.TargetPlatformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=TargetPlatformResolver.class, hint="tycho03", instantiationStrategy="per-lookup")
public class Tycho03TargetPlatformResolver
extends AbstractTargetPlatformResolver
implements TargetPlatformResolver {
    public static final String ROLE_HINT = "tycho03";
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private ArtifactFactory artifactFactory;
    @Requirement
    private PlexusContainer plexus;

    @Override
    public TargetPlatform resolvePlatform(MavenProject project, List<Dependency> dependencies, List<Mirror> mirrors) {
        LinkedHashSet<File> sites = new LinkedHashSet<File>();
        LinkedHashSet<File> features = new LinkedHashSet<File>();
        LinkedHashSet<File> bundles = new LinkedHashSet<File>();
        File installation = this.getEclipseInstallation(this.projects);
        if (installation != null) {
            this.addEclipseInstallation(installation, sites, features, bundles);
        }
        Set<File> extensionLocations = this.getEclipseLocations(this.projects, "eclipse-extension-location", false);
        for (File extensionLocation : extensionLocations) {
            this.addEclipseInstallation(extensionLocation, sites, features, bundles);
        }
        HashMap<Artifact, Exception> exceptions = new HashMap<Artifact, Exception>();
        for (MavenProject otherProject : this.projects) {
            Map versionMap = otherProject.getManagedVersionMap();
            if (versionMap == null) continue;
            for (Artifact artifact : versionMap.values()) {
                try {
                    if ("eclipse-feature".equals(artifact.getType())) {
                        this.resolveFeature(artifact, features, bundles, otherProject.getRemoteArtifactRepositories(), this.localRepository);
                        continue;
                    }
                    if (!"eclipse-plugin".equals(artifact.getType()) && !"eclipse-test-plugin".equals(artifact.getType())) continue;
                    this.resolvePlugin(artifact, bundles, otherProject.getRemoteArtifactRepositories(), this.localRepository);
                }
                catch (Exception e) {
                    exceptions.put(artifact, e);
                }
            }
        }
        DefaultTargetPlatform platform = this.createPlatform();
        for (File site : sites) {
            platform.addSite(site);
        }
        platform.addSite(new File(this.localRepository.getBasedir()));
        for (File feature : features) {
            platform.addArtifactFile("eclipse-feature", feature);
        }
        for (File bundle : bundles) {
            platform.addArtifactFile("eclipse-plugin", bundle);
        }
        this.addProjects(platform);
        return platform;
    }

    private void addEclipseInstallation(File location, Set<File> sites, Set<File> features, Set<File> bundles) {
        EclipseInstallationLayout layout;
        try {
            layout = (EclipseInstallationLayout)((Object)this.plexus.lookup(EclipseInstallationLayout.class));
        }
        catch (ComponentLookupException e) {
            throw new RuntimeException("Could not instantiate required component", e);
        }
        layout.setLocation(location);
        for (File site : layout.getSites()) {
            sites.add(site);
            for (File feature : layout.getFeatures(site)) {
                features.add(feature);
            }
            for (File bundle : layout.getPlugins(site)) {
                bundles.add(bundle);
            }
        }
    }

    private void resolveFeature(Artifact artifact, Set<File> features, Set<File> bundles, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws AbstractArtifactResolutionException, IOException, XmlPullParserException {
        this.resolveArtifact(artifact, remoteRepositories, localRepository);
        Feature feature = Feature.readJar(artifact.getFile());
        if (features.add(artifact.getFile())) {
            Artifact includedArtifact;
            for (PluginRef pluginRef : feature.getPlugins()) {
                try {
                    includedArtifact = this.artifactFactory.createArtifact(pluginRef.getMavenGroupId(), pluginRef.getId(), pluginRef.getMavenVersion(), null, "eclipse-plugin");
                    this.resolvePlugin(includedArtifact, bundles, remoteRepositories, localRepository);
                }
                catch (Exception e) {
                    this.getLogger().warn(e.getMessage());
                }
            }
            for (Feature.FeatureRef featureRef : feature.getIncludedFeatures()) {
                try {
                    includedArtifact = this.artifactFactory.createArtifact(featureRef.getMavenGroupId(), featureRef.getId(), featureRef.getMavenVersion(), null, "eclipse-feature");
                    this.resolveFeature(includedArtifact, features, bundles, remoteRepositories, localRepository);
                }
                catch (Exception e) {
                    this.getLogger().warn(e.getMessage());
                }
            }
        }
    }

    private void assertResolved(Artifact artifact) throws ArtifactNotFoundException {
        if (!artifact.isResolved() || artifact.getFile() == null || !artifact.getFile().canRead()) {
            throw new ArtifactNotFoundException("Artifact is not resolved", artifact);
        }
    }

    private void resolvePlugin(Artifact artifact, Set<File> bundles, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws AbstractArtifactResolutionException {
        this.resolveArtifact(artifact, remoteRepositories, localRepository);
        bundles.add(artifact.getFile());
    }

    private void resolveArtifact(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws AbstractArtifactResolutionException {
        this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
        this.assertResolved(artifact);
    }

    private File getEclipseInstallation(List<MavenProject> projects) {
        Set<File> locations = this.getEclipseLocations(projects, "eclipse-installation", true);
        return !locations.isEmpty() ? locations.iterator().next() : null;
    }

    private Set<File> getEclipseLocations(List<MavenProject> projects, String packaging, boolean singleton) {
        LinkedHashSet<File> installations = new LinkedHashSet<File>();
        for (MavenProject project : projects) {
            Map versionMap = project.getManagedVersionMap();
            if (versionMap == null) continue;
            for (Artifact artifact : versionMap.values()) {
                if (!packaging.equals(artifact.getType())) continue;
                if (!singleton || installations.size() <= 0) {
                    installations.add(artifact.getFile());
                    continue;
                }
                if (installations.contains(artifact.getFile())) continue;
                throw new TargetPlatformException("No more than one eclipse-installation and/or eclipse-distributions");
            }
        }
        return installations;
    }
}

