/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    private final Xpp3Dom dom;

    public Target(Xpp3Dom dom) {
        this.dom = dom;
    }

    public List<Location> getLocations() {
        ArrayList<Location> locations = new ArrayList<Location>();
        Xpp3Dom locationsDom = this.dom.getChild("locations");
        if (locationsDom != null) {
            for (Xpp3Dom locationDom : locationsDom.getChildren("location")) {
                locations.add(new Location(locationDom));
            }
        }
        return Collections.unmodifiableList(locations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Target read(File file) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)file);
        try {
            Target target = new Target(Xpp3DomBuilder.build((Reader)reader));
            return target;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Target target, File file) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)target.dom);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public static class Unit {
        private final Xpp3Dom dom;

        public Unit(Xpp3Dom dom) {
            this.dom = dom;
        }

        public String getId() {
            return this.dom.getAttribute("id");
        }

        public String getVersion() {
            return this.dom.getAttribute("version");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Location {
        private final Xpp3Dom dom;

        public Location(Xpp3Dom dom) {
            this.dom = dom;
        }

        public List<Unit> getUnits() {
            ArrayList<Unit> units = new ArrayList<Unit>();
            for (Xpp3Dom unitDom : this.dom.getChildren("unit")) {
                units.add(new Unit(unitDom));
            }
            return Collections.unmodifiableList(units);
        }

        public String getRepositoryLocation() {
            Xpp3Dom repositoryDom = this.dom.getChild("repository");
            if (repositoryDom == null) {
                return null;
            }
            return repositoryDom.getAttribute("location");
        }

        public void setRepositoryLocation(String locationURI) {
            Xpp3Dom repositoryDom = this.dom.getChild("repository");
            if (repositoryDom != null) {
                repositoryDom.setAttribute("location", locationURI);
            }
        }

        public String getRepositoryId() {
            Xpp3Dom repositoryDom = this.dom.getChild("repository");
            if (repositoryDom == null) {
                return null;
            }
            return repositoryDom.getAttribute("id");
        }
    }
}

