/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.tycho.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.tycho.model.IFeatureRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateSite {
    final Xpp3Dom dom;

    public UpdateSite(Xpp3Dom dom) {
        this.dom = dom;
    }

    public List<FeatureRef> getFeatures() {
        ArrayList<FeatureRef> features = new ArrayList<FeatureRef>();
        for (Xpp3Dom featureDom : this.dom.getChildren("feature")) {
            features.add(new FeatureRef(featureDom));
        }
        return Collections.unmodifiableList(features);
    }

    public Map<String, String> getArchives() {
        HashMap<String, String> archives = new HashMap<String, String>();
        for (Xpp3Dom archiveDom : this.dom.getChildren("archive")) {
            String path = archiveDom.getAttribute("path");
            String url = archiveDom.getAttribute("url");
            archives.put(path, url);
        }
        return Collections.unmodifiableMap(archives);
    }

    public void removeArchives() {
        int i = 0;
        while (i < this.dom.getChildCount()) {
            Xpp3Dom child = this.dom.getChild(i);
            if ("archive".equals(child.getName())) {
                this.dom.removeChild(i);
                continue;
            }
            ++i;
        }
    }

    public static UpdateSite read(File file) throws IOException, XmlPullParserException {
        return UpdateSite.read(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateSite read(InputStream is) throws IOException, XmlPullParserException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)is);
        try {
            UpdateSite updateSite = new UpdateSite(Xpp3DomBuilder.build((Reader)reader));
            return updateSite;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(UpdateSite site, File file) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)site.dom);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public boolean isPack200() {
        String pack200 = this.dom.getAttribute("pack200");
        return "true".equals(pack200);
    }

    public static class FeatureRef
    implements IFeatureRef {
        private final Xpp3Dom dom;

        public FeatureRef(Xpp3Dom dom) {
            this.dom = dom;
        }

        public String getId() {
            return this.dom.getAttribute("id");
        }

        public String getVersion() {
            return this.dom.getAttribute("version");
        }

        public void setUrl(String url) {
            this.dom.setAttribute("url", url);
        }

        public String getUrl() {
            return this.dom.getAttribute("url");
        }

        public void setVersion(String version) {
            this.dom.setAttribute("version", version);
        }

        public String toString() {
            return this.getId() + "_" + this.getVersion();
        }

        public Xpp3Dom getDom() {
            return this.dom;
        }
    }
}

